/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.forms.core.components.internal.servlets;

import com.adobe.cq.forms.core.components.models.form.StaticImage;
import com.day.cq.commons.ImageHelper;
import com.day.cq.commons.ImageResource;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.commons.AbstractImageServlet;
import com.day.cq.wcm.foundation.Image;
import com.day.image.Layer;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=core/fd/components/form/image/v1/image", "sling.servlet.methods=GET"})
public class StaticImageGETServlet
extends AbstractImageServlet {
    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String extension = request.getRequestPathInfo().getExtension();
        if ("json".equals(extension)) {
            StaticImage staticImage = (StaticImage)request.adaptTo(StaticImage.class);
            if (staticImage != null) {
                ObjectMapper mapper = new ObjectMapper();
                response.setContentType("application/json");
                response.getWriter().write(mapper.writeValueAsString((Object)staticImage));
            }
        } else {
            super.doGet(request, response);
        }
    }

    protected Layer createLayer(AbstractImageServlet.ImageContext c) throws RepositoryException, IOException {
        return null;
    }

    protected ImageResource createImageResource(Resource resource) {
        return new Image(resource);
    }

    protected void writeLayer(SlingHttpServletRequest req, SlingHttpServletResponse resp, AbstractImageServlet.ImageContext imageContext, Layer layer) throws IOException, RepositoryException {
        Image image = new Image(imageContext.resource);
        if ((image = this.getImage(resp, imageContext, image)) == null) {
            return;
        }
        layer = this.getLayer(imageContext, image);
        boolean modified = false;
        if (modified = this.isModified(req, resp, imageContext, layer, image, modified)) {
            String mimeType = image.getMimeType();
            if (ImageHelper.getExtensionFromType((String)mimeType) == null) {
                mimeType = "image/png";
            }
            resp.setContentType(mimeType);
            layer.write(mimeType, mimeType.equals("image/gif") ? 255.0 : 1.0, (OutputStream)resp.getOutputStream());
        } else {
            this.extracted(resp, image);
        }
        resp.flushBuffer();
    }

    protected boolean isModified(SlingHttpServletRequest req, SlingHttpServletResponse resp, AbstractImageServlet.ImageContext imageContext, Layer layer, Image image, boolean modified) throws RepositoryException {
        if (layer != null) {
            modified = image.crop(layer) != null;
            modified |= image.rotate(layer) != null;
            modified |= image.resize(layer) != null;
            modified |= this.applyDiff(layer, imageContext);
        }
        if (!WCMMode.DISABLED.equals((Object)WCMMode.fromRequest((ServletRequest)req))) {
            resp.setHeader("Cache-Control", "no-cache");
        }
        if ("image/svg+xml".equals(image.getMimeType())) {
            resp.setHeader("Content-Disposition", "attachment");
        }
        return modified;
    }

    protected Layer getLayer(AbstractImageServlet.ImageContext imageContext, Image image) throws IOException, RepositoryException {
        Layer layer = null;
        try {
            if (image != null) {
                image.loadStyleData(imageContext.style);
                layer = image.getLayer(false, false, false);
            }
        }
        catch (Exception e) {
            System.out.println("Exception occured while rendering image " + e);
        }
        return layer;
    }

    @Nullable
    protected Image getImage(SlingHttpServletResponse resp, AbstractImageServlet.ImageContext imageContext, Image image) throws IOException {
        if (!image.hasContent()) {
            if (imageContext.defaultResource != null) {
                image = this.isRemovedDiff(imageContext) ? new Image(imageContext.diffInfo.getContent()) : new Image(imageContext.defaultResource);
            } else {
                resp.sendError(404);
                return null;
            }
        }
        return image;
    }

    protected void extracted(SlingHttpServletResponse resp, Image image) throws RepositoryException, IOException {
        Property data = image.getData();
        if (data != null) {
            InputStream in = data.getStream();
            resp.setContentLength((int)data.getLength());
            resp.setContentType(image.getMimeType());
            IOUtils.copy((InputStream)in, (OutputStream)resp.getOutputStream());
            in.close();
        }
    }
}

