/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.forms.core.components.internal.models.v1.form;

import com.adobe.aemds.guide.model.ReCaptchaConfigurationModel;
import com.adobe.aemds.guide.service.CloudConfigurationProvider;
import com.adobe.aemds.guide.service.GuideException;
import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.forms.core.components.models.form.Captcha;
import com.adobe.cq.forms.core.components.util.AbstractCaptchaImpl;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.osgi.service.component.annotations.Reference;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class}, adapters={Captcha.class, ComponentExporter.class}, resourceType={"core/fd/components/form/recaptcha/v1/recaptcha"})
@Exporter(name="jackson", extensions={"json"})
public class RecaptchaImpl
extends AbstractCaptchaImpl
implements Captcha {
    @Inject
    private ResourceResolver resourceResolver;
    private Resource resource;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Reference
    private ReCaptchaConfigurationModel reCaptchaConfiguration;
    @OSGiService
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    private CloudConfigurationProvider cloudConfigurationProvider;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @JsonIgnore
    @Named(value="rcCloudServicePath")
    protected String cloudServicePath;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @JsonIgnore
    @Named(value="recaptchaSize")
    protected String size;
    public static final String RECAPTCHA_DEFAULT_DOMAIN = "https://www.recaptcha.net/";
    public static final String RECAPTCHA_DEFAULT_URL = "https://www.recaptcha.net/recaptcha/api.js";
    private static final String RECAPTCHA_SITE_KEY = "siteKey";
    private static final String RECAPTCHA_URI = "uri";
    private static final String RECAPTCHA_SIZE = "size";
    private static final String RECAPTCHA_THEME = "theme";
    private static final String RECAPTCHA_TYPE = "type";

    @Override
    @JsonIgnore
    public String getCloudServicePath() {
        return this.cloudServicePath;
    }

    @JsonIgnore
    public String getSize() {
        return this.size;
    }

    @Override
    public String getProvider() {
        return "recaptcha";
    }

    @Override
    @JsonIgnore
    public Map<String, Object> getCaptchaProperties() throws GuideException {
        LinkedHashMap<String, Object> customCaptchaProperties = new LinkedHashMap<String, Object>();
        String siteKey = null;
        this.resource = this.resourceResolver.getResource(this.getPath());
        if (this.resource != null && this.cloudConfigurationProvider != null) {
            this.reCaptchaConfiguration = this.cloudConfigurationProvider.getRecaptchaCloudConfiguration(this.resource);
            if (this.reCaptchaConfiguration != null) {
                siteKey = this.reCaptchaConfiguration.siteKey();
            }
        }
        customCaptchaProperties.put(RECAPTCHA_SITE_KEY, siteKey);
        customCaptchaProperties.put(RECAPTCHA_URI, RECAPTCHA_DEFAULT_URL);
        customCaptchaProperties.put(RECAPTCHA_SIZE, this.getSize());
        customCaptchaProperties.put(RECAPTCHA_THEME, "light");
        customCaptchaProperties.put(RECAPTCHA_TYPE, "image");
        return customCaptchaProperties;
    }
}

