/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.util;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.export.json.SlingModelFilter;
import com.adobe.cq.wcm.core.components.internal.DataLayerConfig;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.TemplatedResource;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.components.ComponentManager;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.caconfig.ConfigurationBuilder;
import org.apache.sling.models.factory.ModelFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComponentUtils {
    public static final String NN_SLING_CONFIGS = "sling:configs";
    public static final String ID_SEPARATOR = "-";
    private static final int ID_HASH_LENGTH = 10;
    private static final String DATALAYER_ATTRIBUTE_NAME = "isDataLayerEnabled";

    private ComponentUtils() {
    }

    public static boolean isDataLayerEnabled(@Nullable SlingHttpServletRequest request, @NotNull Resource resource) {
        if (request == null) {
            return ComponentUtils.isDataLayerEnabled(resource);
        }
        Object storedValue = request.getAttribute(DATALAYER_ATTRIBUTE_NAME);
        if (storedValue != null) {
            return (Boolean)storedValue;
        }
        boolean isEnabled = ComponentUtils.isDataLayerEnabled(resource);
        request.setAttribute(DATALAYER_ATTRIBUTE_NAME, (Object)isEnabled);
        return isEnabled;
    }

    public static boolean isDataLayerEnabled(@NotNull Resource resource) {
        return Optional.ofNullable(resource.adaptTo(ConfigurationBuilder.class)).map(builder -> (DataLayerConfig)builder.as(DataLayerConfig.class)).map(DataLayerConfig::enabled).orElse(false);
    }

    @NotNull
    public static String getId(@NotNull Resource resource, @Nullable Page currentPage, @Nullable ComponentContext componentContext) {
        return ComponentUtils.getId(resource, currentPage, null, componentContext);
    }

    @NotNull
    public static String getId(@NotNull Resource resource, @Nullable Page currentPage, @Nullable String resourceCallerPath, @Nullable ComponentContext componentContext) {
        return ComponentUtils.getPropertyId(resource).orElseGet(() -> ComponentUtils.generateId(resource, currentPage, resourceCallerPath, componentContext));
    }

    private static Optional<String> getPropertyId(@NotNull Resource resource) {
        return Optional.ofNullable(resource.getValueMap().get("id", String.class)).filter(StringUtils::isNotEmpty).map(StringUtils::trim).map(StringUtils::normalizeSpace).map(val -> StringUtils.replace((String)val, (String)" ", (String)ID_SEPARATOR));
    }

    @NotNull
    private static String generateId(@NotNull Resource resource, @Nullable Page currentPage, @Nullable String resourceCallerPath, @Nullable ComponentContext componentContext) {
        String resourceType = resource.getResourceType();
        String prefix = StringUtils.substringAfterLast((String)resourceType, (String)"/");
        String path = resource.getPath();
        if (currentPage != null && componentContext != null) {
            boolean inTemplate;
            PageManager pageManager = currentPage.getPageManager();
            Page resourcePage = pageManager.getContainingPage(resource);
            Template template = currentPage.getTemplate();
            boolean inCurrentPage = resourcePage != null && StringUtils.equals((CharSequence)resourcePage.getPath(), (CharSequence)currentPage.getPath());
            boolean bl = inTemplate = template != null && path.startsWith(template.getPath());
            if (resourceCallerPath != null) {
                path = resourceCallerPath.concat(resource.getPath());
            } else if (!inCurrentPage && !inTemplate) {
                for (ComponentContext parentContext = componentContext.getParent(); parentContext != null; parentContext = parentContext.getParent()) {
                    Resource parentContextResource = parentContext.getResource();
                    if (parentContextResource == null) continue;
                    Page parentContextPage = pageManager.getContainingPage(parentContextResource);
                    inCurrentPage = parentContextPage != null && StringUtils.equals((CharSequence)parentContextPage.getPath(), (CharSequence)currentPage.getPath());
                    boolean bl2 = inTemplate = template != null && parentContextResource.getPath().startsWith(template.getPath());
                    if (!inCurrentPage && !inTemplate) continue;
                    path = parentContextResource.getPath().concat(resource.getPath());
                    break;
                }
            }
        }
        return ComponentUtils.generateId(prefix, path);
    }

    @NotNull
    public static String generateId(@NotNull String prefix, @NotNull String path) {
        return StringUtils.join((Object[])new String[]{prefix, ID_SEPARATOR, StringUtils.substring((String)DigestUtils.sha256Hex((String)path), (int)0, (int)10)});
    }

    @Nullable
    public static Resource getFeaturedImage(@NotNull Page page) {
        return page.getContentResource("cq:featuredimage");
    }

    @NotNull
    public static Resource getEffectiveResource(@NotNull Resource resource, @Nullable SlingHttpServletRequest request) {
        if (resource instanceof TemplatedResource) {
            return resource;
        }
        Resource res = resource;
        while (res instanceof ResourceWrapper) {
            if (!((res = ((ResourceWrapper)res).getResource()) instanceof TemplatedResource)) continue;
            return resource;
        }
        return Optional.ofNullable((Resource)resource.adaptTo(TemplatedResource.class)).orElseGet(() -> Optional.ofNullable(request).map(r -> (Resource)r.adaptTo(TemplatedResource.class)).orElse(resource));
    }

    @NotNull
    public static List<Resource> getChildComponents(@NotNull Resource resource, @Nullable SlingHttpServletRequest request) {
        return Optional.ofNullable(resource.getResourceResolver().adaptTo(ComponentManager.class)).map(componentManager -> StreamSupport.stream(ComponentUtils.getEffectiveResource(resource, request).getChildren().spliterator(), false).filter(res -> Objects.nonNull(componentManager.getComponentOfResource(res)))).orElseGet(Stream::empty).collect(Collectors.toList());
    }

    public static LinkedHashMap<String, ComponentExporter> getComponentModels(@NotNull SlingModelFilter slingModelFilter, @NotNull ModelFactory modelFactory, @NotNull SlingHttpServletRequest request, @NotNull Class<ComponentExporter> modelClass) {
        return ComponentUtils.getComponentModels(slingModelFilter, modelFactory, ComponentUtils.getChildComponents(request.getResource(), request), request, modelClass);
    }

    public static LinkedHashMap<String, ComponentExporter> getComponentModels(@NotNull SlingModelFilter slingModelFilter, @NotNull ModelFactory modelFactory, @NotNull List<Resource> childComponents, @NotNull SlingHttpServletRequest request, @NotNull Class<ComponentExporter> modelClass) {
        LinkedHashMap<String, ComponentExporter> models = new LinkedHashMap<String, ComponentExporter>();
        slingModelFilter.filterChildResources(childComponents).forEach(child -> {
            ComponentExporter model = (ComponentExporter)modelFactory.getModelFromWrappedRequest(request, child, modelClass);
            if (model != null) {
                models.put(child.getName(), model);
            }
        });
        return models;
    }
}

