/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.util;

import com.adobe.cq.wcm.core.components.models.datalayer.ComponentData;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.ComponentDataBuilder;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.DataLayerBuilder;
import com.adobe.cq.wcm.core.components.util.ComponentUtils;
import com.adobe.cq.wcm.style.ComponentStyleInfo;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentContext;
import java.util.Calendar;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public abstract class AbstractComponentImpl
implements com.adobe.cq.wcm.core.components.models.Component {
    @Self
    protected SlingHttpServletRequest request;
    @SlingObject
    protected Resource resource;
    @ScriptVariable(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    protected Component component;
    @ScriptVariable(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    protected ComponentContext componentContext;
    @ScriptVariable(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private Page currentPage;
    private String id;
    private Boolean dataLayerEnabled;
    private ComponentData componentData;

    protected Page getCurrentPage() {
        return this.currentPage;
    }

    protected void setCurrentPage(Page currentPage) {
        this.currentPage = currentPage;
    }

    @Override
    @NotNull
    public String getId() {
        if (this.id == null) {
            String resourceCallerPath = (String)this.request.getAttribute("resourceCallerPath");
            this.id = ComponentUtils.getId(this.resource, this.currentPage, resourceCallerPath, this.componentContext);
        }
        return this.id;
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.resource.getResourceType();
    }

    @Override
    @Nullable
    public ComponentData getData() {
        if (this.componentData == null) {
            if (this.dataLayerEnabled == null) {
                this.dataLayerEnabled = this.currentPage != null ? Boolean.valueOf(ComponentUtils.isDataLayerEnabled(this.request, this.currentPage.getContentResource())) : Boolean.valueOf(ComponentUtils.isDataLayerEnabled(this.request, this.resource));
            }
            if (this.dataLayerEnabled.booleanValue()) {
                this.componentData = this.getComponentData();
            }
        }
        return this.componentData;
    }

    @Override
    @Nullable
    public String getAppliedCssClasses() {
        return Optional.ofNullable(this.resource.adaptTo(ComponentStyleInfo.class)).map(ComponentStyleInfo::getAppliedCssClasses).filter(StringUtils::isNotBlank).orElse(null);
    }

    @NotNull
    protected ComponentData getComponentData() {
        return ((ComponentDataBuilder)((ComponentDataBuilder)DataLayerBuilder.forComponent().withId(this::getId).withLastModifiedDate(() -> Optional.ofNullable(this.resource.getValueMap().get("jcr:lastModified", Calendar.class)).map(Calendar::getTime).orElseGet(() -> Optional.ofNullable(this.resource.getValueMap().get("jcr:created", Calendar.class)).map(Calendar::getTime).orElse(null)))).withType(() -> this.resource.getResourceType())).build();
    }
}

