/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.servlets.contentfragment;

import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.VariationDef;
import com.adobe.cq.wcm.core.components.internal.servlets.contentfragment.AbstractContentFragmentDataSourceServlet;
import com.adobe.granite.ui.components.ExpressionResolver;
import com.day.cq.i18n.I18n;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=core/wcm/components/contentfragment/v1/datasource/variations", "sling.servlet.methods=GET", "sling.servlet.extensions=html"})
public class VariationsDataSourceServlet
extends AbstractContentFragmentDataSourceServlet<Variation> {
    public static final String RESOURCE_TYPE = "core/wcm/components/contentfragment/v1/datasource/variations";
    @Reference
    private transient ExpressionResolver expressionResolver;

    @Override
    @NotNull
    protected ExpressionResolver getExpressionResolver() {
        return this.expressionResolver;
    }

    @Override
    @NotNull
    protected List<Variation> getItems(@NotNull ContentFragment fragment, @NotNull SlingHttpServletRequest request) {
        LinkedList<Variation> variations = new LinkedList<Variation>();
        variations.add(new Variation("master", new I18n((HttpServletRequest)request).get("Master")));
        Iterator iterator = fragment.listAllVariations();
        while (iterator.hasNext()) {
            VariationDef variation = (VariationDef)iterator.next();
            variations.add(new Variation(variation.getName(), variation.getTitle()));
        }
        return variations;
    }

    @Override
    @NotNull
    protected String getTitle(@NotNull Variation variation) {
        return variation.getTitle();
    }

    @Override
    @NotNull
    protected String getValue(@NotNull Variation variation) {
        return variation.getName();
    }

    protected static class Variation {
        private String name;
        private String title;

        Variation(@NotNull String name, @NotNull String title) {
            this.name = name;
            this.title = title;
        }

        @NotNull
        private String getName() {
            return this.name;
        }

        @NotNull
        private String getTitle() {
            return this.title;
        }
    }
}

