/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.servlets.contentfragment;

import com.adobe.cq.wcm.core.components.internal.servlets.contentfragment.AbstractDataSourceServlet;
import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.ExpressionResolver;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.EmptyDataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import java.util.Iterator;
import java.util.LinkedList;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=core/wcm/components/contentfragmentlist/v1/datasource/elements", "sling.servlet.resourceTypes=core/wcm/components/contentfragmentlist/v2/datasource/elements", "sling.servlet.resourceTypes=core/wcm/components/contentfragmentlist/v1/datasource/orderby", "sling.servlet.resourceTypes=core/wcm/components/contentfragmentlist/v2/datasource/orderby", "sling.servlet.methods=GET", "sling.servlet.extensions=html"})
public class ModelElementsDataSourceServlet
extends AbstractDataSourceServlet {
    public static final String RESOURCE_TYPE_V1 = "core/wcm/components/contentfragmentlist/v1/datasource/elements";
    public static final String RESOURCE_TYPE_V2 = "core/wcm/components/contentfragmentlist/v2/datasource/elements";
    public static final String RESOURCE_TYPE_ORDER_BY_V1 = "core/wcm/components/contentfragmentlist/v1/datasource/orderby";
    public static final String RESOURCE_TYPE_ORDER_BY_V2 = "core/wcm/components/contentfragmentlist/v2/datasource/orderby";
    protected static final String PARAMETER_AND_PN_MODEL_PATH = "modelPath";
    @Reference
    private transient ExpressionResolver expressionResolver;

    @Override
    @NotNull
    protected ExpressionResolver getExpressionResolver() {
        return this.expressionResolver;
    }

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) {
        String pathToCFModelElements;
        ResourceResolver resourceResolver;
        Resource cfModelElementRoot;
        Config config;
        ValueMap componentValueMap;
        boolean isOrderBy;
        RequestParameter modelPathRequestParameter = request.getRequestParameter(PARAMETER_AND_PN_MODEL_PATH);
        boolean bl = isOrderBy = request.getResource().isResourceType(RESOURCE_TYPE_ORDER_BY_V1) || request.getResource().isResourceType(RESOURCE_TYPE_ORDER_BY_V2);
        String modelPath = modelPathRequestParameter != null ? modelPathRequestParameter.getString() : ((componentValueMap = this.getComponentValueMap(config = this.getConfig(request), request)) != null ? (String)componentValueMap.get(PARAMETER_AND_PN_MODEL_PATH, String.class) : null);
        DataSource dataSource = EmptyDataSource.instance();
        if (modelPath != null && (cfModelElementRoot = (resourceResolver = request.getResourceResolver()).getResource(pathToCFModelElements = String.format("%s/%s/model/cq:dialog/content/items", modelPath, "jcr:content"))) != null) {
            Iterator resourceIterator = cfModelElementRoot.listChildren();
            LinkedList<Resource> resourceList = new LinkedList<Resource>();
            if (isOrderBy) {
                resourceList.add(this.createResource(resourceResolver, "Created", "jcr:created"));
                resourceList.add(this.createResource(resourceResolver, "Last Modified", "jcr:content/jcr:lastModified"));
            }
            while (resourceIterator.hasNext()) {
                String valueValue;
                Resource elementResource = (Resource)resourceIterator.next();
                ValueMap valueMap = elementResource.getValueMap();
                String textValue = (String)valueMap.get("fieldLabel", (Object)(valueValue = (String)valueMap.get("name", (Object)"")));
                if (textValue.equals(valueValue)) {
                    textValue = (String)valueMap.get("cfm-element", (Object)valueValue);
                }
                if (isOrderBy && StringUtils.isNotEmpty((CharSequence)valueValue)) {
                    valueValue = "jcr:content/data/master/" + valueValue;
                }
                String metaType = (String)valueMap.get("metaType", (Object)"");
                if (isOrderBy && !StringUtils.startsWith((CharSequence)metaType, (CharSequence)"text-") && !StringUtils.equals((CharSequence)metaType, (CharSequence)"date") && !StringUtils.equals((CharSequence)metaType, (CharSequence)"number")) continue;
                Resource syntheticResource = this.createResource(resourceResolver, textValue, valueValue);
                resourceList.add(syntheticResource);
            }
            dataSource = new SimpleDataSource(resourceList.iterator());
        }
        request.setAttribute(DataSource.class.getName(), (Object)dataSource);
    }
}

