/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.servlets;

import com.adobe.cq.wcm.core.components.internal.servlets.TextValueDataResourceSource;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.model.WorkflowModel;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=core/wcm/components/form/container/v1/datasource/workflowmodel", "sling.servlet.methods=GET", "sling.servlet.extensions=html"})
public class WorkflowModelDataSourceServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 9114656669504668093L;
    public static final String RESOURCE_TYPE = "core/wcm/components/form/container/v1/datasource/workflowmodel";

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            WorkflowSession workflowSession = (WorkflowSession)request.getResourceResolver().adaptTo(WorkflowSession.class);
            ArrayList<WorkflowModelResource> resources = new ArrayList<WorkflowModelResource>();
            if (workflowSession != null) {
                WorkflowModel[] models;
                for (WorkflowModel model : models = workflowSession.getModels()) {
                    resources.add(new WorkflowModelResource(model, request.getResourceResolver()));
                }
            }
            SimpleDataSource dataSource = new SimpleDataSource(resources.iterator());
            request.setAttribute(DataSource.class.getName(), (Object)dataSource);
        }
        catch (WorkflowException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private static class WorkflowModelResource
    extends TextValueDataResourceSource {
        private final WorkflowModel model;

        WorkflowModelResource(WorkflowModel model, ResourceResolver resourceResolver) {
            super(resourceResolver, "", "sling:nonexisting");
            this.model = model;
        }

        @Override
        public String getText() {
            return this.model.getTitle();
        }

        @Override
        public String getValue() {
            return this.model.getId();
        }
    }
}

