/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.servlets;

import com.adobe.cq.wcm.core.components.internal.servlets.TextValueDataResourceSource;
import com.adobe.granite.ui.clientlibs.ClientLibrary;
import com.adobe.granite.ui.clientlibs.HtmlLibraryManager;
import com.adobe.granite.ui.clientlibs.LibraryType;
import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=core/wcm/components/commons/datasources/clientlibrarycategories/v1", "sling.servlet.methods=GET", "sling.servlet.extensions=html"})
public class ClientLibraryCategoriesDataSourceServlet
extends SlingSafeMethodsServlet {
    public static final String RESOURCE_TYPE = "core/wcm/components/commons/datasources/clientlibrarycategories/v1";
    public static final String PN_LIBRARY_TYPE = "type";
    @Reference
    private transient HtmlLibraryManager htmlLibraryManager;

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        String type;
        ValueMap dataSourceValueMap;
        LibraryType libraryType = null;
        Resource dataSourceResource = request.getResource().getChild(Config.DATASOURCE);
        if (dataSourceResource != null && (dataSourceValueMap = ResourceUtil.getValueMap((Resource)dataSourceResource)) != null && (type = (String)dataSourceValueMap.get(PN_LIBRARY_TYPE, String.class)) != null) {
            type = type.toUpperCase();
            libraryType = LibraryType.valueOf((String)type);
        }
        SimpleDataSource clientLibraryCategoriesDataSource = new SimpleDataSource(this.getCategoryResourceList(request, libraryType).iterator());
        request.setAttribute(DataSource.class.getName(), (Object)clientLibraryCategoriesDataSource);
    }

    private List<Resource> getCategoryResourceList(@NotNull SlingHttpServletRequest request, LibraryType libraryType) {
        ArrayList<Resource> categoryResourceList = new ArrayList<Resource>();
        HashSet<String> clientLibraryCategories = new HashSet<String>();
        for (Object library : this.htmlLibraryManager.getLibraries().values()) {
            for (String category : library.getCategories()) {
                clientLibraryCategories.add(category);
            }
        }
        if (libraryType != null) {
            Collection clientLibraries = this.htmlLibraryManager.getLibraries(clientLibraryCategories.toArray(new String[clientLibraryCategories.size()]), libraryType, true, true);
            clientLibraryCategories.clear();
            for (ClientLibrary library : clientLibraries) {
                for (String category : library.getCategories()) {
                    clientLibraryCategories.add(category);
                }
            }
        }
        for (String category : clientLibraryCategories) {
            categoryResourceList.add((Resource)new CategoryResource(category, request.getResourceResolver()));
        }
        return categoryResourceList;
    }

    private static class CategoryResource
    extends TextValueDataResourceSource {
        private final String category;

        CategoryResource(String category, ResourceResolver resourceResolver) {
            super(resourceResolver, "", "sling:nonexisting");
            this.category = category;
        }

        @Override
        public String getText() {
            return this.category;
        }

        @Override
        public String getValue() {
            return this.category;
        }
    }
}

