/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.services;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sling.models.spi.ImplementationPicker;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.propertytypes.ServiceRanking;

@Component
@ServiceRanking(value=1)
public class LatestVersionImplementationPicker
implements ImplementationPicker {
    private static final Pattern INTERNAL_MODEL_PATTERN = Pattern.compile("^com\\.adobe\\.cq\\.wcm\\.core\\.components\\.internal\\.models\\.v(\\d+)\\.\\S*$");
    private static final String CORE_COMPONENTS_MODELS = "com.adobe.cq.wcm.core.components.models";

    public Class<?> pick(Class<?> adapterType, Class<?>[] implementationsTypes, Object adaptable) {
        if (adapterType.getPackage().getName().equals(CORE_COMPONENTS_MODELS)) {
            return Arrays.stream(implementationsTypes).filter(aClass -> !aClass.getName().startsWith("com.adobe.cq") || aClass.getName().startsWith("com.adobe.cq.wcm.core.components.internal.models")).min((o1, o2) -> {
                Matcher m1 = INTERNAL_MODEL_PATTERN.matcher(o1.getName());
                Matcher m2 = INTERNAL_MODEL_PATTERN.matcher(o2.getName());
                if (m1.matches() && m2.matches()) {
                    return Integer.parseInt(m2.group(1)) - Integer.parseInt(m1.group(1));
                }
                return m1.matches() ? 1 : (m2.matches() ? -1 : 0);
            }).orElse(implementationsTypes[0]);
        }
        return null;
    }
}

