/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v3;

import com.adobe.cq.ui.wcm.commons.config.NextGenDynamicMediaConfig;
import com.adobe.cq.wcm.core.components.commons.editor.nextgendm.NextGenDMThumbnail;
import com.adobe.cq.wcm.core.components.internal.models.v3.ImageImpl;
import com.adobe.cq.wcm.core.components.internal.models.v3.NextGenDMImageURIBuilder;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={NextGenDMThumbnail.class}, resourceType={"core/wcm/components/image/v3/image/nextgendmthumbnail"})
@Exporter(name="jackson", extensions={"json"})
public class NextGenDMThumbnailImpl
implements NextGenDMThumbnail {
    private static final Logger LOGGER = LoggerFactory.getLogger(NextGenDMThumbnailImpl.class);
    protected static final String RESOURCE_TYPE = "core/wcm/components/image/v3/image/nextgendmthumbnail";
    @SlingObject
    protected Resource resource;
    @Self
    private SlingHttpServletRequest request;
    @Inject
    @Optional
    private NextGenDynamicMediaConfig nextGenDynamicMediaConfig;
    private String componentPath;
    private String src;
    private String altText = "";

    @PostConstruct
    private void initModel() {
        this.componentPath = this.request.getRequestPathInfo().getSuffix();
        Resource component = this.request.getResourceResolver().getResource(this.componentPath);
        ValueMap properties = component.getValueMap();
        String fileReference = (String)properties.get("fileReference", String.class);
        String smartCrop = (String)properties.get("smartCrop", String.class);
        ValueMap configs = this.resource.getValueMap();
        int width = (Integer)configs.get("width", (Object)480);
        int height = (Integer)configs.get("height", (Object)480);
        this.altText = (String)configs.get("alt", (Object)"image thumbnail");
        if (ImageImpl.isNgdmImageReference(fileReference)) {
            NextGenDMImageURIBuilder builder = new NextGenDMImageURIBuilder(this.nextGenDynamicMediaConfig, fileReference).withPreferWebp(true).withWidth(width).withHeight(height);
            if (StringUtils.isNotEmpty((CharSequence)smartCrop)) {
                builder.withSmartCrop(smartCrop);
            }
            this.src = builder.build();
        }
    }

    @Override
    public String getSrc() {
        return this.src;
    }

    @Override
    public String getAlt() {
        return this.altText;
    }
}

