/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v2;

import com.adobe.cq.wcm.core.components.commons.link.Link;
import com.adobe.cq.wcm.core.components.commons.link.LinkManager;
import com.adobe.cq.wcm.core.components.internal.resource.CoreResourceWrapper;
import com.adobe.cq.wcm.core.components.models.datalayer.PageData;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.DataLayerBuilder;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.PageDataBuilder;
import com.adobe.cq.wcm.core.components.util.ComponentUtils;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.components.Component;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageListItemImpl
extends com.adobe.cq.wcm.core.components.internal.models.v1.PageListItemImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(PageListItemImpl.class);
    private final Component component;
    private Resource listResource;
    private Resource teaserResource;
    protected boolean showDescription;
    protected boolean linkItems;
    private final Map<String, Object> overriddenProperties = new HashMap<String, Object>();
    private final List<String> hiddenProperties = new ArrayList<String>();

    public PageListItemImpl(@NotNull LinkManager linkManager, @NotNull Page page, String parentId, Component component) {
        super(linkManager, page, parentId, component);
        this.component = component;
    }

    public PageListItemImpl(@NotNull LinkManager linkManager, @NotNull Page page, String parentId, Component component, boolean showDescription, boolean linkItems, Resource resource) {
        super(linkManager, page, parentId, component);
        this.component = component;
        this.showDescription = showDescription;
        this.linkItems = linkItems;
        this.listResource = resource;
    }

    public PageListItemImpl(@NotNull Link link, @NotNull Page page, String parentId, Component component, boolean showDescription, boolean linkItems, Resource resource) {
        super(link, page, parentId, component);
        this.component = component;
        this.showDescription = showDescription;
        this.linkItems = linkItems;
        this.listResource = resource;
    }

    @Override
    @JsonIgnore(value=false)
    @Nullable
    public Link<Page> getLink() {
        return super.getLink();
    }

    @Override
    @JsonIgnore
    @Deprecated
    public String getURL() {
        return super.getURL();
    }

    @Override
    @JsonIgnore
    public Resource getTeaserResource() {
        if (this.teaserResource == null && this.component != null) {
            String delegateResourceType = (String)this.component.getProperties().get("teaserDelegate", String.class);
            if (StringUtils.isEmpty((CharSequence)delegateResourceType)) {
                LOGGER.error("In order for list rendering delegation to work correctly you need to set up the teaserDelegate property on the {} component; its value has to point to the resource type of a teaser component.", (Object)this.component.getPath());
            } else {
                Resource resourceToBeWrapped = ComponentUtils.getFeaturedImage(this.page);
                if (resourceToBeWrapped != null) {
                    ValueMap valueMap = resourceToBeWrapped.getValueMap();
                    String inheritedFileReference = (String)valueMap.get("fileReference", String.class);
                    this.overriddenProperties.put("fileReference", inheritedFileReference);
                    this.overriddenProperties.put("externalImageResourcePath", resourceToBeWrapped.getPath());
                    this.overriddenProperties.put("jcr:title", this.getTitle());
                    if (this.showDescription) {
                        this.overriddenProperties.put("jcr:description", this.getDescription());
                    }
                } else {
                    resourceToBeWrapped = this.page.getContentResource();
                    if (resourceToBeWrapped == null) {
                        return null;
                    }
                    if (!this.showDescription) {
                        this.hiddenProperties.add("jcr:description");
                    }
                }
                if (this.linkItems) {
                    String target;
                    this.overriddenProperties.put("linkURL", this.getPath());
                    Link<Page> itemLink = this.getLink();
                    if (itemLink != null && StringUtils.isNotBlank((CharSequence)(target = itemLink.getHtmlAttributes().get("target")))) {
                        this.overriddenProperties.put("linkTarget", target);
                    }
                }
                this.teaserResource = new CoreResourceWrapper(this.listResource, delegateResourceType, this.hiddenProperties, this.overriddenProperties);
            }
        }
        return this.teaserResource;
    }

    @Override
    @NotNull
    protected PageData getComponentData() {
        return ((PageDataBuilder)((PageDataBuilder)DataLayerBuilder.extending(super.getComponentData()).asPage().withTitle(this::getTitle)).withLinkUrl(() -> this.link.getMappedURL())).build();
    }
}

