/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1.contentfragment;

import com.adobe.cq.dam.cfm.ContentElement;
import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.ContentFragmentException;
import com.adobe.cq.dam.cfm.ContentVariation;
import com.adobe.cq.dam.cfm.FragmentData;
import com.adobe.cq.dam.cfm.converter.ContentTypeConverter;
import com.adobe.cq.wcm.core.components.internal.ContentFragmentUtils;
import com.adobe.cq.wcm.core.components.models.contentfragment.DAMContentFragment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Exporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Exporter(name="jackson", extensions={"json"})
public class DAMContentFragmentImpl
implements DAMContentFragment {
    private static final Logger LOG = LoggerFactory.getLogger(DAMContentFragmentImpl.class);
    private static final String MASTER_VARIATION = "master";
    private final ContentFragment contentFragment;
    private final String variationName;
    private final String[] elementNames;
    private final String resourceType;
    private String type;
    private List<DAMContentFragment.DAMContentElement> elements;
    private Map<String, DAMContentFragment.DAMContentElement> exportedElements;

    public DAMContentFragmentImpl(@NotNull Resource contentFragmentResource, @NotNull ContentTypeConverter contentTypeConverter, String variationName, String[] elementNames) {
        this.variationName = variationName;
        this.resourceType = contentFragmentResource.getResourceType();
        if (elementNames == null) {
            this.elementNames = null;
        } else {
            this.elementNames = new String[elementNames.length];
            System.arraycopy(elementNames, 0, this.elementNames, 0, elementNames.length);
        }
        this.contentFragment = (ContentFragment)contentFragmentResource.adaptTo(ContentFragment.class);
        if (this.contentFragment == null) {
            LOG.error("Content Fragment can not be initialized because '{}' is not a content fragment.", (Object)contentFragmentResource.getPath());
        } else {
            this.type = ContentFragmentUtils.getType(this.contentFragment);
            Iterator<ContentElement> contentElementIterator = ContentFragmentUtils.filterElements(this.contentFragment, elementNames);
            this.exportedElements = new LinkedHashMap<String, DAMContentFragment.DAMContentElement>();
            while (contentElementIterator.hasNext()) {
                ContentElement contentElement = contentElementIterator.next();
                ContentVariation variation = null;
                if (StringUtils.isNotEmpty((CharSequence)variationName) && !MASTER_VARIATION.equals(variationName) && (variation = contentElement.getVariation(variationName)) == null) {
                    LOG.warn("Non-existing variation '{}' of element '{}'", (Object)variationName, (Object)contentElement.getName());
                }
                this.exportedElements.put(contentElement.getName(), new DAMContentElementImpl(contentTypeConverter, contentElement, variation));
            }
            this.elements = new ArrayList<DAMContentFragment.DAMContentElement>(this.exportedElements.values());
        }
    }

    @Override
    @Nullable
    public String getTitle() {
        return this.contentFragment.getTitle();
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.contentFragment.getDescription();
    }

    @Override
    @Nullable
    public String getType() {
        return this.type;
    }

    @Override
    @NotNull
    public String getName() {
        return this.contentFragment.getName();
    }

    @Override
    @Nullable
    public List<DAMContentFragment.DAMContentElement> getElements() {
        return Collections.unmodifiableList(this.elements);
    }

    @Override
    @NotNull
    public Map<String, DAMContentFragment.DAMContentElement> getExportedElements() {
        return this.exportedElements;
    }

    @Override
    @NotNull
    public String[] getExportedElementsOrder() {
        return ContentFragmentUtils.getItemsOrder(this.exportedElements);
    }

    @Override
    @Nullable
    public List<Resource> getAssociatedContent() {
        return IteratorUtils.toList((Iterator)this.contentFragment.getAssociatedContent());
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.resourceType;
    }

    @Override
    @NotNull
    public String getEditorJSON() {
        return ContentFragmentUtils.getEditorJSON(this.contentFragment, this.variationName, this.elementNames);
    }

    public static class DAMContentElementImpl
    implements DAMContentFragment.DAMContentElement {
        private static final Logger LOG = LoggerFactory.getLogger(DAMContentElementImpl.class);
        private static final String TEXT_HTML = "text/html";
        private final ContentTypeConverter converter;
        private final ContentElement element;
        private final ContentVariation variation;
        private String htmlValue;

        public DAMContentElementImpl(@NotNull ContentTypeConverter converter, @NotNull ContentElement element, @Nullable ContentVariation variation) {
            this.converter = converter;
            this.element = element;
            this.variation = variation;
        }

        @Override
        @NotNull
        public String getName() {
            return this.element.getName();
        }

        @Override
        @Nullable
        public String getTitle() {
            return this.element.getTitle();
        }

        private FragmentData getData() {
            if (this.variation != null) {
                return this.variation.getValue();
            }
            return this.element.getValue();
        }

        @Override
        @NotNull
        public String getDataType() {
            return this.getData().getDataType().getTypeString();
        }

        @Override
        @Nullable
        public Object getValue() {
            return this.getData().getValue();
        }

        @Override
        @Nullable
        public <T> T getValue(Class<T> var1) {
            return (T)this.getData().getValue(var1);
        }

        @Override
        @NotNull
        public String getExportedType() {
            FragmentData value = this.getData();
            String type = value.getContentType();
            if (type == null) {
                type = value.getDataType().getTypeString();
            }
            return type;
        }

        private String getContentType() {
            return this.getData().getContentType();
        }

        @Override
        public boolean isMultiLine() {
            String contentType = this.getContentType();
            return contentType != null && contentType.startsWith("text/") && !this.isMultiValue();
        }

        @Override
        public boolean isMultiValue() {
            return this.getData().getDataType().isMultiValue();
        }

        @Override
        @Nullable
        public String getHtml() {
            if (!this.isMultiLine()) {
                return null;
            }
            String contentType = this.getContentType();
            Object[] values = (String[])this.getData().getValue(String[].class);
            String value = null;
            if (values != null) {
                value = StringUtils.join((Object[])values, (String)", ");
            }
            if (TEXT_HTML.equals(contentType)) {
                return value;
            }
            if (this.htmlValue == null) {
                try {
                    this.htmlValue = this.converter.convertToHTML(value, contentType);
                }
                catch (ContentFragmentException e) {
                    LOG.warn("Could not convert value to HTML", (Throwable)e);
                    return null;
                }
            }
            return this.htmlValue;
        }
    }
}

