/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.models.TableOfContents;
import com.adobe.cq.wcm.core.components.models.datalayer.ComponentData;
import com.adobe.cq.wcm.core.components.util.AbstractComponentImpl;
import com.day.cq.wcm.api.designer.Style;
import java.util.Arrays;
import javax.annotation.PostConstruct;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={TableOfContents.class, ComponentExporter.class}, resourceType={"core/wcm/components/tableofcontents/v1/tableofcontents"})
@Exporter(name="jackson", extensions={"json"})
public class TableOfContentsImpl
extends AbstractComponentImpl
implements TableOfContents {
    public static final String RESOURCE_TYPE = "core/wcm/components/tableofcontents/v1/tableofcontents";
    public static final String TOC_REQUEST_ATTR_FLAG = "cmp-toc-present";
    public static final TableOfContents.ListType DEFAULT_LIST_TYPE = TableOfContents.ListType.bulleted;
    public static final TableOfContents.HeadingLevel DEFAULT_START_LEVEL = TableOfContents.HeadingLevel.h1;
    public static final TableOfContents.HeadingLevel DEFAULT_STOP_LEVEL = TableOfContents.HeadingLevel.h6;
    public static final String NO_RESTRICTION = "norestriction";
    @Self(injectionStrategy=InjectionStrategy.REQUIRED)
    private SlingHttpServletRequest slingHttpServletRequest;
    @ScriptVariable
    protected Style currentStyle;
    @ValueMapValue(name="listType", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String listType;
    @ValueMapValue(name="startLevel", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String startLevel;
    @ValueMapValue(name="stopLevel", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String stopLevel;
    private String restrictListType;
    private String restrictStartLevel;
    private String restrictStopLevel;
    private String[] includeClasses;
    private String[] ignoreClasses;

    @PostConstruct
    private void initModel() {
        this.restrictListType = (String)this.currentStyle.get("restrictListType", String.class);
        this.restrictStartLevel = (String)this.currentStyle.get("restrictStartLevel", String.class);
        this.restrictStopLevel = (String)this.currentStyle.get("restrictStopLevel", String.class);
        this.includeClasses = (String[])this.currentStyle.get("includeClasses", String[].class);
        this.ignoreClasses = (String[])this.currentStyle.get("ignoreClasses", String[].class);
        this.slingHttpServletRequest.setAttribute(TOC_REQUEST_ATTR_FLAG, (Object)true);
    }

    @Override
    public TableOfContents.ListType getListType() {
        return this.restrictListType == null || NO_RESTRICTION.contentEquals(this.restrictListType) ? (this.listType != null ? TableOfContents.ListType.fromString(this.listType) : DEFAULT_LIST_TYPE) : TableOfContents.ListType.fromString(this.restrictListType);
    }

    @Override
    public TableOfContents.HeadingLevel getStartLevel() {
        return this.restrictStartLevel == null || NO_RESTRICTION.contentEquals(this.restrictStartLevel) ? (this.startLevel != null ? TableOfContents.HeadingLevel.fromString(this.startLevel) : DEFAULT_START_LEVEL) : TableOfContents.HeadingLevel.fromString(this.restrictStartLevel);
    }

    @Override
    public TableOfContents.HeadingLevel getStopLevel() {
        return this.restrictStopLevel == null || NO_RESTRICTION.contentEquals(this.restrictStopLevel) ? (this.stopLevel != null ? TableOfContents.HeadingLevel.fromString(this.stopLevel) : DEFAULT_STOP_LEVEL) : TableOfContents.HeadingLevel.fromString(this.restrictStopLevel);
    }

    @Override
    public String[] getIncludeClasses() {
        return this.includeClasses != null ? Arrays.copyOf(this.includeClasses, this.includeClasses.length) : null;
    }

    @Override
    public String[] getIgnoreClasses() {
        return this.ignoreClasses != null ? Arrays.copyOf(this.ignoreClasses, this.ignoreClasses.length) : null;
    }

    @Override
    public ComponentData getData() {
        return null;
    }
}

