/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.wcm.core.components.commons.link.Link;
import com.adobe.cq.wcm.core.components.commons.link.LinkManager;
import com.adobe.cq.wcm.core.components.models.NavigationItem;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedirectItemImpl
implements NavigationItem {
    private final String redirectTarget;
    private final Page page;
    protected final Link link;

    public RedirectItemImpl(@NotNull String redirectTarget, @NotNull SlingHttpServletRequest request, @NotNull LinkManager linkManager) {
        this.redirectTarget = redirectTarget;
        this.page = this.getRedirectPage(request);
        this.link = linkManager.get(this.page).build();
    }

    private Page getRedirectPage(@NotNull SlingHttpServletRequest request) {
        Page page = null;
        ResourceResolver resourceResolver = request.getResourceResolver();
        Resource targetResource = resourceResolver.getResource(this.redirectTarget);
        PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
        if (pageManager != null && targetResource != null) {
            page = pageManager.getContainingPage(targetResource);
        }
        return page;
    }

    @Override
    @Deprecated
    @Nullable
    public Page getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public String getURL() {
        return this.link.getURL();
    }
}

