/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.export.json.SlingModelFilter;
import com.adobe.cq.wcm.core.components.models.Component;
import com.adobe.cq.wcm.core.components.models.PanelContainerItem;
import com.adobe.cq.wcm.core.components.models.datalayer.ComponentData;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.ComponentDataBuilder;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.DataLayerBuilder;
import com.adobe.cq.wcm.core.components.util.ComponentUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.AbstractMap;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.factory.ModelFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PanelContainerItemImpl
implements PanelContainerItem {
    private static final String PANEL_ITEM_ID_PREFIX = "item";
    @NotNull
    private final Resource resource;
    @NotNull
    private final String id;
    @NotNull
    private final String dataType;

    public PanelContainerItemImpl(@NotNull Resource resource, @NotNull Component container) {
        this.resource = resource;
        this.id = ComponentUtils.generateId(StringUtils.join((Object[])new String[]{container.getId(), "-", PANEL_ITEM_ID_PREFIX}), this.resource.getPath());
        CharSequence[] charSequenceArray = new CharSequence[2];
        charSequenceArray[0] = Optional.ofNullable(container.getData()).map(ComponentData::getType).orElseGet(container::getExportedType);
        charSequenceArray[1] = PANEL_ITEM_ID_PREFIX;
        this.dataType = String.join((CharSequence)"/", charSequenceArray);
    }

    @Override
    @NotNull
    public Resource getResource() {
        return this.resource;
    }

    @Override
    @NotNull
    public String getName() {
        return this.resource.getName();
    }

    @Override
    @Nullable
    public String getTitle() {
        return Optional.ofNullable(this.resource.getValueMap().get("cq:panelTitle", String.class)).orElseGet(() -> (String)this.resource.getValueMap().get("jcr:title", String.class));
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    private Date getLastModifiedDate() {
        return Optional.ofNullable(this.resource.getValueMap().get("jcr:lastModified", Calendar.class)).map(Calendar::getTime).orElseGet(() -> Optional.ofNullable(this.resource.getValueMap().get("jcr:created", Calendar.class)).map(Calendar::getTime).orElse(null));
    }

    @Override
    @NotNull
    public ComponentData getData() {
        return ((ComponentDataBuilder)((ComponentDataBuilder)((ComponentDataBuilder)DataLayerBuilder.forComponent().withId(this::getId).withLastModifiedDate(this::getLastModifiedDate)).withType(() -> this.dataType)).withTitle(this::getTitle)).build();
    }

    public Optional<Map.Entry<String, ComponentExporter>> getComponentExporter(@NotNull SlingModelFilter slingModelFilter, @NotNull ModelFactory modelFactory, @NotNull SlingHttpServletRequest request) {
        return ComponentUtils.getComponentModels(slingModelFilter, modelFactory, Collections.singletonList(this.getResource()), request, ComponentExporter.class).entrySet().stream().findFirst().map(i -> new AbstractMap.SimpleEntry(i.getKey(), new JsonWrapper((ComponentExporter)i.getValue())));
    }

    private final class JsonWrapper
    implements ComponentExporter {
        @NotNull
        private final ComponentExporter inner;

        JsonWrapper(ComponentExporter inner) {
            this.inner = inner;
        }

        @JsonUnwrapped
        @NotNull
        public ComponentExporter getInner() {
            return this.inner;
        }

        @JsonProperty(value="cq:panelTitle")
        @JsonInclude
        public String getPanelTitle() {
            return PanelContainerItemImpl.this.getTitle();
        }

        @JsonIgnore
        @NotNull
        public String getExportedType() {
            return this.inner.getExportedType();
        }
    }
}

