/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.commons.link.LinkManager;
import com.adobe.cq.wcm.core.components.internal.LocalizationUtils;
import com.adobe.cq.wcm.core.components.internal.Utils;
import com.adobe.cq.wcm.core.components.internal.models.v1.NavigationItemImpl;
import com.adobe.cq.wcm.core.components.models.Navigation;
import com.adobe.cq.wcm.core.components.models.NavigationItem;
import com.adobe.cq.wcm.core.components.util.AbstractComponentImpl;
import com.day.cq.commons.Filter;
import com.day.cq.wcm.api.LanguageManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageFilter;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.designer.Style;
import com.day.cq.wcm.msm.api.LiveRelationshipManager;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.PostConstruct;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Navigation.class, ComponentExporter.class}, resourceType={"core/wcm/components/navigation/v1/navigation"})
@Exporter(name="jackson", extensions={"json"})
public class NavigationImpl
extends AbstractComponentImpl
implements Navigation {
    public static final String RESOURCE_TYPE = "core/wcm/components/navigation/v1/navigation";
    private static final String PN_ACCESSIBILITY_LABEL = "accessibilityLabel";
    @Self
    private SlingHttpServletRequest request;
    @Self
    private LinkManager linkManager;
    @ScriptVariable
    private Page currentPage;
    @ScriptVariable
    private Style currentStyle;
    @OSGiService
    private LanguageManager languageManager;
    @OSGiService
    private LiveRelationshipManager relationshipManager;
    @Nullable
    private String accessibilityLabel;
    private int structureStart;
    private int structureDepth;
    private Page navigationRootPage;
    private List<NavigationItem> items;

    @PostConstruct
    private void initModel() {
        boolean skipNavigationRoot;
        ValueMap properties = this.resource.getValueMap();
        this.structureDepth = (Integer)properties.get("structureDepth", this.currentStyle.get("structureDepth", (Object)-1));
        boolean collectAllPages = (Boolean)properties.get("collectAllPages", this.currentStyle.get("collectAllPages", (Object)true));
        if (collectAllPages) {
            this.structureDepth = -1;
        }
        this.structureStart = this.currentStyle.containsKey((Object)"structureStart") || properties.containsKey((Object)"structureStart") ? (Integer)properties.get("structureStart", this.currentStyle.get("structureStart", (Object)1)) : ((skipNavigationRoot = ((Boolean)properties.get("skipNavigationRoot", this.currentStyle.get("skipNavigationRoot", (Object)true))).booleanValue()) ? 1 : 0);
    }

    private Page getNavigationRoot() {
        if (this.navigationRootPage == null) {
            String navigationRootPath = Optional.ofNullable(this.resource.getValueMap().get("navigationRoot", String.class)).orElseGet(() -> (String)this.currentStyle.get("navigationRoot", String.class));
            this.navigationRootPage = LocalizationUtils.getLocalPage(navigationRootPath, this.currentPage, this.request.getResourceResolver(), this.languageManager, this.relationshipManager).orElseGet(() -> this.currentPage.getPageManager().getPage(navigationRootPath));
        }
        return this.navigationRootPage;
    }

    @Override
    public List<NavigationItem> getItems() {
        if (this.items == null) {
            this.items = Optional.ofNullable(this.getNavigationRoot()).map(navigationRoot -> this.getRootItems((Page)navigationRoot, this.structureStart)).orElseGet(Stream::empty).map(item -> this.createNavigationItem((Page)item, this.getItems((Page)item))).collect(Collectors.toList());
        }
        return Collections.unmodifiableList(this.items);
    }

    protected NavigationItem newNavigationItem(Page page, boolean active, boolean current, @NotNull LinkManager linkManager, int level, List<NavigationItem> children, String parentId, Component component) {
        return new NavigationItemImpl(page, active, current, linkManager, level, children, parentId, component);
    }

    @Override
    @Nullable
    public String getAccessibilityLabel() {
        if (this.accessibilityLabel == null) {
            this.accessibilityLabel = (String)this.resource.getValueMap().get(PN_ACCESSIBILITY_LABEL, String.class);
        }
        return this.accessibilityLabel;
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.resource.getResourceType();
    }

    private List<NavigationItem> getItems(@NotNull Page subtreeRoot) {
        if (this.structureDepth < 0 || subtreeRoot.getDepth() - this.getNavigationRoot().getDepth() < this.structureDepth) {
            Iterator childIterator = subtreeRoot.listChildren((Filter)new PageFilter());
            return StreamSupport.stream(((Iterable)() -> childIterator).spliterator(), false).map(item -> this.createNavigationItem((Page)item, this.getItems((Page)item))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private Stream<Page> getRootItems(@NotNull Page navigationRoot, int structureStart) {
        if (structureStart < 1) {
            return Stream.of(navigationRoot);
        }
        Iterator childIterator = navigationRoot.listChildren((Filter)new PageFilter());
        return StreamSupport.stream(((Iterable)() -> childIterator).spliterator(), false).flatMap(child -> this.getRootItems((Page)child, structureStart - 1));
    }

    private NavigationItem createNavigationItem(@NotNull Page page, @NotNull List<NavigationItem> children) {
        int level = page.getDepth() - (this.getNavigationRoot().getDepth() + this.structureStart);
        boolean current = this.checkCurrent(page);
        boolean selected = this.checkSelected(page, current);
        return this.newNavigationItem(page, selected, current, this.linkManager, level, children, this.getId(), this.component);
    }

    private boolean checkSelected(@NotNull Page page, boolean current) {
        return current || this.currentPage.getPath().startsWith(page.getPath() + "/");
    }

    private boolean checkCurrent(@NotNull Page page) {
        return this.currentPage.equals(page) || this.currentPageIsRedirectTarget(page);
    }

    private boolean currentPageIsRedirectTarget(@NotNull Page page) {
        return this.currentPage.equals(Utils.resolveRedirects(page).getLeft());
    }
}

