/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.export.json.ContainerExporter;
import com.adobe.cq.wcm.core.components.internal.ContentFragmentUtils;
import com.adobe.cq.wcm.core.components.internal.models.v1.ExperienceFragmentDataImpl;
import com.adobe.cq.wcm.core.components.models.ExperienceFragment;
import com.adobe.cq.wcm.core.components.util.AbstractComponentImpl;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.factory.ModelFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={ExperienceFragment.class, ComponentExporter.class, ContainerExporter.class}, resourceType={"core/wcm/components/experiencefragment/v1/experiencefragment", "core/wcm/components/experiencefragment/v2/experiencefragment"})
@Exporter(name="jackson", extensions={"json"})
public class ExperienceFragmentImpl
extends AbstractComponentImpl
implements ExperienceFragment {
    public static final String RESOURCE_TYPE_V1 = "core/wcm/components/experiencefragment/v1/experiencefragment";
    public static final String RESOURCE_TYPE_V2 = "core/wcm/components/experiencefragment/v2/experiencefragment";
    private static final String CSS_EMPTY_CLASS = "empty";
    private static final String CSS_BASE_CLASS = "aem-xf";
    @Self
    private SlingHttpServletRequest request;
    @Self
    private ExperienceFragmentDataImpl data;
    @OSGiService
    private ModelFactory modelFactory;
    private String name;
    private String classNames;
    private LinkedHashMap<String, ComponentExporter> children;

    @Override
    @Nullable
    public String getLocalizedFragmentVariationPath() {
        return this.data.getLocalizedFragmentVariationPath();
    }

    @Override
    @JsonIgnore
    @Nullable
    public String getName() {
        if (this.name == null) {
            this.name = Optional.ofNullable(this.request.getResourceResolver().adaptTo(PageManager.class)).flatMap(pm -> Optional.ofNullable(this.getLocalizedFragmentVariationPath()).map(arg_0 -> ((PageManager)pm).getContainingPage(arg_0))).map(Page::getParent).map(Page::getName).orElse(null);
        }
        return this.name;
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.request.getResource().getResourceType();
    }

    @Override
    @NotNull
    public Map<String, ? extends ComponentExporter> getExportedItems() {
        return this.getChildren();
    }

    @Override
    @NotNull
    public String[] getExportedItemsOrder() {
        return this.getChildren().keySet().toArray(new String[0]);
    }

    @Override
    @JsonProperty(value="classNames")
    @NotNull
    public String getCssClassNames() {
        if (this.classNames == null) {
            this.classNames = Stream.of(CSS_BASE_CLASS, this.getExportedItems().isEmpty() ? CSS_EMPTY_CLASS : "", (String)this.request.getResource().getValueMap().get("cq:cssClass", (Object)"")).filter(StringUtils::isNotBlank).collect(Collectors.joining(" "));
        }
        return this.classNames;
    }

    @Override
    @JsonInclude
    public boolean isConfigured() {
        return StringUtils.isNotEmpty((CharSequence)this.getLocalizedFragmentVariationPath()) && !this.getExportedItems().isEmpty();
    }

    private LinkedHashMap<String, ComponentExporter> getChildren() {
        if (this.children == null) {
            this.children = Optional.ofNullable(this.getLocalizedFragmentVariationPath()).filter(StringUtils::isNotBlank).map(arg_0 -> ((ResourceResolver)this.resource.getResourceResolver()).getResource(arg_0)).map(Resource::listChildren).map(it -> ContentFragmentUtils.getComponentExporters(it, this.modelFactory, this.request, this.resource)).orElseGet(LinkedHashMap::new);
        }
        return this.children;
    }
}

