/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.wcm.core.components.util.LocalizationUtils;
import com.day.cq.wcm.api.LanguageManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.msm.api.LiveRelationshipManager;
import com.day.text.Text;
import java.io.Serializable;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={Resource.class, SlingHttpServletRequest.class})
public class ExperienceFragmentDataImpl {
    private static final char PATH_DELIMITER_CHAR = '/';
    private static final String CONTENT_ROOT = "/content";
    @SlingObject
    private ResourceResolver resourceResolver;
    @OSGiService
    private LanguageManager languageManager;
    @OSGiService
    private LiveRelationshipManager relationshipManager;
    @ScriptVariable(injectionStrategy=InjectionStrategy.OPTIONAL)
    private Page currentPage;
    private final Resource resource;
    private String localizedFragmentVariationPath;

    public ExperienceFragmentDataImpl(SlingHttpServletRequest request) {
        this(request.getResource());
    }

    public ExperienceFragmentDataImpl(Resource resource) {
        this.resource = resource;
    }

    @PostConstruct
    protected void postConstruct() {
        PageManager pageManager;
        if (this.currentPage == null && (pageManager = (PageManager)this.resourceResolver.adaptTo(PageManager.class)) != null) {
            this.currentPage = pageManager.getContainingPage(this.resource);
        }
    }

    @Nullable
    private String getXfLocalizationRoot(@Nullable String xfPath, @Nullable String currentPageRoot) {
        int xfRootDepth;
        String[] xfPathTokens;
        if (StringUtils.isNotEmpty((CharSequence)xfPath) && StringUtils.isNotEmpty((CharSequence)currentPageRoot) && this.resourceResolver.getResource(xfPath) != null && this.resourceResolver.getResource(currentPageRoot) != null && (xfPathTokens = Text.explode((String)xfPath, (int)47)).length >= (xfRootDepth = Text.explode((String)currentPageRoot, (int)47).length + 1)) {
            String[] xfRootTokens = new String[xfRootDepth];
            System.arraycopy(xfPathTokens, 0, xfRootTokens, 0, xfRootDepth);
            return StringUtils.join((Object[])new Serializable[]{Character.valueOf('/'), Text.implode((String[])xfRootTokens, (String)Character.toString('/'))});
        }
        return null;
    }

    private boolean resourceExists(@Nullable String path) {
        return StringUtils.isNotEmpty((CharSequence)path) && this.resourceResolver.getResource(path) != null;
    }

    private boolean inTemplate() {
        return Optional.ofNullable(this.currentPage).map(Page::getTemplate).map(Template::getPath).filter(this.resource.getPath()::startsWith).isPresent();
    }

    private boolean isExperienceFragmentVariation(@Nullable String path) {
        return Optional.ofNullable(path).filter(StringUtils::isNotEmpty).map(arg_0 -> ((ResourceResolver)this.resourceResolver).getResource(arg_0)).map(Resource::getValueMap).map(vm -> (String)vm.get("cq:xfVariantType", String.class)).isPresent();
    }

    @Nullable
    public String getLocalizedFragmentVariationPath() {
        if (this.localizedFragmentVariationPath != null) {
            return this.localizedFragmentVariationPath;
        }
        String fragmentVariationPath = (String)this.resource.getValueMap().get("fragmentVariationPath", String.class);
        if (this.currentPage != null && this.inTemplate()) {
            Resource pageResource = Optional.ofNullable(this.currentPage).map(p -> (Resource)p.adaptTo(Resource.class)).orElse(null);
            String currentPageRootPath = pageResource != null ? LocalizationUtils.getLocalizationRoot(pageResource, this.resourceResolver, this.languageManager, this.relationshipManager) : null;
            String xfRootPath = this.getXfLocalizationRoot(fragmentVariationPath, currentPageRootPath);
            if (StringUtils.isNotEmpty((CharSequence)currentPageRootPath) && StringUtils.isNotEmpty((CharSequence)xfRootPath)) {
                String xfRelativePath = StringUtils.substring((String)fragmentVariationPath, (int)xfRootPath.length());
                String localizedXfRootPath = StringUtils.replace((String)currentPageRootPath, (String)CONTENT_ROOT, (String)"/content/experience-fragments", (int)1);
                this.localizedFragmentVariationPath = StringUtils.join((Object[])new Serializable[]{localizedXfRootPath, xfRelativePath, Character.valueOf('/'), "jcr:content"});
            }
        }
        String xfContentPath = String.join((CharSequence)Character.toString('/'), fragmentVariationPath, "jcr:content");
        if (!this.resourceExists(this.localizedFragmentVariationPath) && this.resourceExists(xfContentPath)) {
            this.localizedFragmentVariationPath = xfContentPath;
        }
        if (!this.isExperienceFragmentVariation(this.localizedFragmentVariationPath)) {
            this.localizedFragmentVariationPath = null;
        }
        return this.localizedFragmentVariationPath;
    }
}

