/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.link;

import com.adobe.cq.wcm.core.components.commons.link.Link;
import com.adobe.cq.wcm.core.components.commons.link.LinkBuilder;
import com.adobe.cq.wcm.core.components.internal.Utils;
import com.adobe.cq.wcm.core.components.internal.link.LinkImpl;
import com.adobe.cq.wcm.core.components.internal.link.LinkManagerImpl;
import com.adobe.cq.wcm.core.components.internal.link.LinkUtil;
import com.adobe.cq.wcm.core.components.services.link.PathProcessor;
import com.day.cq.dam.api.Asset;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkBuilderImpl
implements LinkBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinkBuilderImpl.class);
    public static final String HTML_EXTENSION = ".html";
    SlingHttpServletRequest request;
    List<PathProcessor> pathProcessors;
    boolean shadowingDisabled;
    Resource linkConfiguration;
    String linkUrlPropertyName = "linkURL";
    Page targetPage;
    Asset targetAsset;
    String linkUrl;
    Map<String, String> linkAttributes = new HashMap<String, String>();
    Object reference;

    public LinkBuilderImpl(Resource resource, SlingHttpServletRequest req, List<PathProcessor> pathProcs, boolean shadowingDisabled) {
        this.linkConfiguration = resource;
        this.request = req;
        this.pathProcessors = pathProcs;
        this.shadowingDisabled = shadowingDisabled;
    }

    public LinkBuilderImpl(Page page, SlingHttpServletRequest req, List<PathProcessor> pathProcs, boolean shadowingDisabled) {
        this.targetPage = page;
        this.request = req;
        this.pathProcessors = pathProcs;
        this.shadowingDisabled = shadowingDisabled;
    }

    public LinkBuilderImpl(Asset asset, SlingHttpServletRequest req, List<PathProcessor> pathProcs) {
        this.targetAsset = asset;
        this.request = req;
        this.pathProcessors = pathProcs;
    }

    public LinkBuilderImpl(String url, SlingHttpServletRequest req, List<PathProcessor> pathProcs, boolean shadowingDisabled) {
        this.linkUrl = url;
        this.request = req;
        this.pathProcessors = pathProcs;
        this.shadowingDisabled = shadowingDisabled;
    }

    @Override
    @NotNull
    public LinkBuilder withLinkUrlPropertyName(@NotNull String name) {
        this.linkUrlPropertyName = name;
        return this;
    }

    @Override
    @NotNull
    public LinkBuilder withLinkTarget(@NotNull String target) {
        String resolvedLinkTarget = this.validateAndResolveLinkTarget(target);
        this.linkAttributes.put("linkTarget", resolvedLinkTarget);
        return this;
    }

    @Override
    @NotNull
    public LinkBuilder withLinkAttribute(@NotNull String name, @Nullable String value) {
        String validatedLinkAttributeValue = this.validateLinkAttributeValue(value);
        this.linkAttributes.put(name, validatedLinkAttributeValue);
        return this;
    }

    @Override
    @NotNull
    public Link build() {
        if (this.linkConfiguration != null) {
            String linkTitleAttribute;
            String linkAccessibilityLabel;
            ValueMap props = this.linkConfiguration.getValueMap();
            this.linkUrl = (String)props.get(this.linkUrlPropertyName, String.class);
            String linkTarget = (String)props.get("linkTarget", String.class);
            if (StringUtils.isNotEmpty((CharSequence)linkTarget)) {
                this.withLinkTarget(linkTarget);
            }
            if (StringUtils.isNotEmpty((CharSequence)(linkAccessibilityLabel = (String)props.get("linkAccessibilityLabel", String.class)))) {
                this.withLinkAttribute("linkAccessibilityLabel", linkAccessibilityLabel);
            }
            if (StringUtils.isNotEmpty((CharSequence)(linkTitleAttribute = (String)props.get("linkTitleAttribute", String.class)))) {
                this.withLinkAttribute("linkTitleAttribute", linkTitleAttribute);
            }
        } else if (this.targetPage != null) {
            this.linkUrl = this.targetPage.getPath();
        } else if (this.targetAsset != null) {
            this.linkUrl = this.targetAsset.getPath();
        }
        Asset asset = this.getAsset(this.linkUrl);
        Page page = this.getPage(this.linkUrl).orElse(null);
        if (asset != null) {
            this.reference = asset;
        } else if (page != null) {
            Pair<Page, String> pair = this.resolvePage(page);
            this.reference = pair.getLeft();
            this.linkUrl = StringUtils.isNotEmpty((CharSequence)((CharSequence)pair.getRight())) ? (String)pair.getRight() : this.linkUrl;
        }
        String resolvedLinkURL = this.validateAndResolveLinkURL(this.linkUrl);
        Map<String, String> htmlAttributes = this.mapLinkAttributesToHtml();
        return this.buildLink(resolvedLinkURL, this.request, htmlAttributes);
    }

    @NotNull
    private Link buildLink(String path, SlingHttpServletRequest request, Map<String, String> htmlAttributes) {
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            try {
                path = LinkUtil.decode(path);
            }
            catch (Exception ex) {
                String message = "Failed to decode url '{}': {}";
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.warn(message, new Object[]{path, ex.getMessage(), ex});
                }
                LOGGER.warn(message, (Object)path, (Object)ex.getMessage());
            }
            String decodedPath = path;
            return this.pathProcessors.stream().filter(pathProcessor -> pathProcessor.accepts(decodedPath, request)).findFirst().map(pathProcessor -> new LinkImpl<Object>(pathProcessor.sanitize(decodedPath, request), pathProcessor.map(decodedPath, request), pathProcessor.externalize(decodedPath, request), this.reference, pathProcessor.processHtmlAttributes(decodedPath, htmlAttributes))).orElse(new LinkImpl<Object>(path, path, path, this.reference, htmlAttributes));
        }
        return new LinkImpl<Object>(path, path, path, this.reference, htmlAttributes);
    }

    @NotNull
    private Map<String, String> mapLinkAttributesToHtml() {
        return new HashMap<String, String>(){
            {
                this.put("target", LinkBuilderImpl.this.linkAttributes.get("linkTarget"));
                this.put("aria-label", LinkBuilderImpl.this.linkAttributes.get("linkAccessibilityLabel"));
                this.put("title", LinkBuilderImpl.this.linkAttributes.get("linkTitleAttribute"));
            }
        };
    }

    @Nullable
    private String validateAndResolveLinkTarget(@Nullable String linkTarget) {
        return Optional.ofNullable(linkTarget).filter(LinkManagerImpl.VALID_LINK_TARGETS::contains).orElse(null);
    }

    @Nullable
    private String validateLinkAttributeValue(@Nullable String value) {
        return Optional.ofNullable(value).filter(StringUtils::isNotBlank).map(String::trim).orElse(null);
    }

    @Nullable
    private String validateAndResolveLinkURL(@Nullable String linkURL) {
        return Optional.ofNullable(linkURL).filter(StringUtils::isNotEmpty).map(this::getLinkURL).orElse(null);
    }

    @NotNull
    private String getLinkURL(@NotNull String path) {
        return this.getPage(path).map(this::getPageLinkURL).orElse(path);
    }

    @NotNull
    private String getPageLinkURL(@NotNull Page page) {
        return page.getPath() + HTML_EXTENSION;
    }

    @Nullable
    private Asset getAsset(@NotNull String path) {
        return Optional.ofNullable(this.request.getResourceResolver().getResource(path)).map(assetRes -> (Asset)assetRes.adaptTo(Asset.class)).orElse(null);
    }

    @NotNull
    private Optional<Page> getPage(@Nullable String path) {
        return Optional.ofNullable(path).flatMap(p -> Optional.ofNullable(this.request.getResourceResolver().adaptTo(PageManager.class)).map(pm -> pm.getPage(p)));
    }

    @NotNull
    private Pair<Page, String> resolvePage(@NotNull Page page) {
        ImmutablePair pair;
        ImmutablePair immutablePair = pair = !this.shadowingDisabled ? Utils.resolveRedirects(page) : new ImmutablePair((Object)page, null);
        if (pair.getLeft() == null && StringUtils.isNotEmpty((CharSequence)((CharSequence)pair.getRight()))) {
            return new ImmutablePair((Object)page, pair.getRight());
        }
        Page resolved = (Page)Optional.ofNullable(pair.getLeft()).orElse(page);
        return new ImmutablePair((Object)resolved, (Object)this.getPageLinkURL(resolved));
    }
}

