/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal;

import com.day.cq.wcm.api.LanguageManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import com.day.cq.wcm.msm.api.LiveRelationship;
import com.day.cq.wcm.msm.api.LiveRelationshipManager;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocalizationUtils {
    private LocalizationUtils() {
    }

    public static Optional<Page> getLocalPage(@Nullable String referencePagePath, @NotNull Page currentPage, @NotNull ResourceResolver resourceResolver, @NotNull LanguageManager languageManager, @NotNull LiveRelationshipManager relationshipManager) {
        return Optional.ofNullable(currentPage.getPageManager().getPage(referencePagePath)).flatMap(referencePage -> LocalizationUtils.getLocalPage(referencePage, currentPage, resourceResolver, languageManager, relationshipManager));
    }

    public static Optional<Page> getLocalPage(@NotNull Page referencePage, @NotNull Page currentPage, @NotNull ResourceResolver resourceResolver, @NotNull LanguageManager languageManager, @NotNull LiveRelationshipManager relationshipManager) {
        Page referencePageLanguageRoot = Optional.ofNullable(referencePage.getPath()).map(arg_0 -> ((ResourceResolver)resourceResolver).getResource(arg_0)).map(arg_0 -> ((LanguageManager)languageManager).getLanguageRoot(arg_0)).orElse(null);
        Page currentPageLanguageRoot = languageManager.getLanguageRoot(currentPage.getContentResource());
        if (referencePageLanguageRoot != null && currentPageLanguageRoot != null && !referencePageLanguageRoot.equals(currentPageLanguageRoot)) {
            return Optional.ofNullable(referencePage.getPageManager().getPage(ResourceUtil.normalize((String)String.join((CharSequence)"/", currentPageLanguageRoot.getPath(), LocalizationUtils.getRelativePath(referencePageLanguageRoot, referencePage)))));
        }
        try {
            String currentPagePath = currentPage.getPath() + "/";
            return Optional.of(Optional.ofNullable(relationshipManager.getLiveRelationships((Resource)referencePage.adaptTo(Resource.class), null, null)).map(liveRelationshipIterator -> StreamSupport.stream(((Iterable)() -> liveRelationshipIterator).spliterator(), false)).orElseGet(Stream::empty).map(LiveRelationship::getTargetPath).filter(target -> currentPagePath.startsWith(target + "/")).map(arg_0 -> ((PageManager)referencePage.getPageManager()).getPage(arg_0)).findFirst().orElse(referencePage));
        }
        catch (WCMException wCMException) {
            return Optional.empty();
        }
    }

    @Nullable
    private static String getRelativePath(@NotNull Page root, @NotNull Page child) {
        if (child.equals(root)) {
            return ".";
        }
        if ((child.getPath() + "/").startsWith(root.getPath())) {
            return child.getPath().substring(root.getPath().length() + 1);
        }
        return null;
    }
}

