/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.servlets.contentfragment;

import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.wcm.core.components.internal.servlets.contentfragment.AbstractDataSourceServlet;
import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.EmptyDataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractContentFragmentDataSourceServlet<T>
extends AbstractDataSourceServlet {
    public static final String PN_FRAGMENT_PATH = "fragmentPath";

    @NotNull
    protected abstract List<T> getItems(@NotNull ContentFragment var1, @NotNull SlingHttpServletRequest var2);

    @NotNull
    protected abstract String getTitle(@NotNull T var1);

    @NotNull
    protected abstract String getValue(@NotNull T var1);

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        DataSource elements = EmptyDataSource.instance();
        ContentFragment fragment = this.getContentFragment(request);
        if (fragment != null) {
            List<T> items = this.getItems(fragment, request);
            LinkedList<Resource> resources = new LinkedList<Resource>();
            ResourceResolver resolver = request.getResourceResolver();
            for (T item : items) {
                Resource resource = this.createResource(resolver, this.getTitle(item), this.getValue(item));
                resources.add(resource);
            }
            elements = new SimpleDataSource(resources.iterator());
        }
        request.setAttribute(DataSource.class.getName(), (Object)elements);
    }

    @Nullable
    private ContentFragment getContentFragment(@NotNull SlingHttpServletRequest request) {
        Config config = this.getConfig(request);
        ValueMap map = this.getComponentValueMap(config, request);
        if (config == null) {
            return null;
        }
        String fragmentPath = this.getParameter(config, PN_FRAGMENT_PATH, request);
        if (StringUtils.isEmpty((CharSequence)fragmentPath)) {
            String string = fragmentPath = map != null ? (String)map.get(PN_FRAGMENT_PATH, String.class) : null;
        }
        if (StringUtils.isEmpty((CharSequence)fragmentPath)) {
            return null;
        }
        Resource fragmentResource = request.getResourceResolver().getResource(fragmentPath);
        if (fragmentResource == null) {
            return null;
        }
        return (ContentFragment)fragmentResource.adaptTo(ContentFragment.class);
    }
}

