/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.servlets;

import com.adobe.cq.wcm.core.components.internal.models.v1.TableOfContentsImpl;
import com.adobe.cq.wcm.core.components.internal.servlets.CharResponseWrapper;
import com.adobe.cq.wcm.core.components.models.TableOfContents;
import com.day.cq.wcm.api.WCMMode;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.servlets.annotations.SlingServletFilter;
import org.apache.sling.servlets.annotations.SlingServletFilterScope;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Designate(ocd=Config.class)
@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={Filter.class}, property={"service.rankingInteger=999"})
@SlingServletFilter(scope={SlingServletFilterScope.REQUEST}, pattern="/content/.*", resourceTypes={"cq:Page"}, extensions={"html"}, methods={"GET"})
public class TableOfContentsFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableOfContentsFilter.class);
    private boolean enabled;

    @Activate
    protected void activate(Config config) {
        this.enabled = config.enabled();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        LOGGER.debug("Initialising {}", (Object)TableOfContentsFilter.class.getName());
    }

    public void destroy() {
        LOGGER.debug("Destroying {}", (Object)TableOfContentsFilter.class.getName());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.enabled) {
            LOGGER.debug("{} not enabled, bypassing it", (Object)TableOfContentsFilter.class.getName());
            chain.doFilter(request, response);
            return;
        }
        CharResponseWrapper responseWrapper = new CharResponseWrapper((HttpServletResponse)response);
        chain.doFilter(request, (ServletResponse)responseWrapper);
        String originalContent = responseWrapper.toString();
        Boolean containsTableOfContents = (Boolean)request.getAttribute("cmp-toc-present");
        if (containsTableOfContents == null || !containsTableOfContents.booleanValue()) {
            LOGGER.debug("request attribute {} not present or set to false, bypassing the filter {}", (Object)"cmp-toc-present", (Object)TableOfContentsFilter.class.getName());
            response.getWriter().write(originalContent);
            return;
        }
        if (responseWrapper.getContentType() == null || !responseWrapper.getContentType().contains("text/html")) {
            LOGGER.debug("Response content type not \"text/html\", bypassing filter");
            response.getWriter().write(originalContent);
            return;
        }
        Document document = Jsoup.parse((String)originalContent);
        Elements tocPlaceholderElements = document.getElementsByClass("cmp-toc__placeholder");
        HashMap<String, Integer> customIDs = new HashMap<String, Integer>();
        for (Element tocPlaceholderElement : tocPlaceholderElements) {
            Element tableOfContents = this.getTableOfContents(tocPlaceholderElement, customIDs);
            String id = tocPlaceholderElement.id();
            tocPlaceholderElement.empty();
            tocPlaceholderElement.clearAttributes();
            tocPlaceholderElement.addClass("cmp-toc__content");
            if (!id.isEmpty()) {
                tocPlaceholderElement.id(id);
            }
            if (tableOfContents == null) continue;
            tocPlaceholderElement.appendChild((Node)tableOfContents);
            WCMMode wcmMode = WCMMode.fromRequest((ServletRequest)request);
            if (wcmMode != WCMMode.EDIT && wcmMode != WCMMode.PREVIEW) continue;
            Elements tocTemplatePlaceholderElement = tocPlaceholderElement.parent().select(".cmp-toc__template-placeholder");
            tocTemplatePlaceholderElement.remove();
        }
        CharArrayWriter charWriter = new CharArrayWriter();
        charWriter.write(document.outerHtml());
        String alteredContent = charWriter.toString();
        response.getWriter().write(alteredContent);
    }

    private Element getTableOfContents(Element tocPlaceholderElement, Map<String, Integer> customIDs) {
        String includeCssSelector;
        String[] ignoreClasses;
        TableOfContents.ListType listType = tocPlaceholderElement.hasAttr("data-cmp-toc-list-type") ? TableOfContents.ListType.fromString(tocPlaceholderElement.attr("data-cmp-toc-list-type")) : TableOfContentsImpl.DEFAULT_LIST_TYPE;
        String listTag = listType.getTagName();
        TableOfContents.HeadingLevel startLevel = tocPlaceholderElement.hasAttr("data-cmp-toc-start-level") ? TableOfContents.HeadingLevel.fromStringOrDefault(tocPlaceholderElement.attr("data-cmp-toc-start-level"), TableOfContentsImpl.DEFAULT_START_LEVEL) : TableOfContentsImpl.DEFAULT_START_LEVEL;
        TableOfContents.HeadingLevel stopLevel = tocPlaceholderElement.hasAttr("data-cmp-toc-stop-level") ? TableOfContents.HeadingLevel.fromStringOrDefault(tocPlaceholderElement.attr("data-cmp-toc-stop-level"), TableOfContentsImpl.DEFAULT_STOP_LEVEL) : TableOfContentsImpl.DEFAULT_STOP_LEVEL;
        String[] includeClasses = tocPlaceholderElement.hasAttr("data-cmp-toc-include-classes") ? tocPlaceholderElement.attr("data-cmp-toc-include-classes").split(",") : null;
        String[] stringArray = ignoreClasses = tocPlaceholderElement.hasAttr("data-cmp-toc-ignore-classes") ? tocPlaceholderElement.attr("data-cmp-toc-ignore-classes").split(",") : null;
        if (startLevel.getIntValue() > stopLevel.getIntValue()) {
            LOGGER.warn("Invalid start and stop levels, startLevel={}, stopLevel={}", (Object)startLevel.getValue(), (Object)stopLevel.getValue());
            return null;
        }
        Document document = tocPlaceholderElement.ownerDocument();
        if (includeClasses == null || includeClasses.length == 0) {
            ArrayList<String> selectors = new ArrayList<String>();
            for (int level = startLevel.getIntValue().intValue(); level <= stopLevel.getIntValue(); ++level) {
                selectors.add(this.getHeadingTagName(level));
            }
            includeCssSelector = StringUtils.join(selectors, (String)",");
        } else {
            includeCssSelector = this.getCssSelectorString(includeClasses, startLevel.getIntValue(), stopLevel.getIntValue());
        }
        Elements includeElements = document.select(includeCssSelector);
        HashSet ignoreElementsSet = new HashSet();
        if (ignoreClasses != null && ignoreClasses.length != 0) {
            String ignoreCssSelector = this.getCssSelectorString(ignoreClasses, startLevel.getIntValue(), stopLevel.getIntValue());
            Elements ignoreElements = document.select(ignoreCssSelector);
            ignoreElementsSet = new HashSet(ignoreElements);
        }
        ArrayList<Element> validElements = new ArrayList<Element>();
        for (Element element : includeElements) {
            if (ignoreElementsSet.contains(element) || "".contentEquals(element.text().trim())) continue;
            validElements.add(element);
        }
        return this.getNestedList(listTag, validElements.listIterator(), 0, customIDs);
    }

    private String getCssSelectorString(String[] classNames, int startLevel, int stopLevel) {
        ArrayList<String> selectors = new ArrayList<String>();
        for (String className : classNames) {
            for (int level = startLevel; level <= stopLevel; ++level) {
                selectors.add("." + className + " " + this.getHeadingTagName(level));
                selectors.add(this.getHeadingTagName(level) + "." + className);
            }
        }
        return StringUtils.join(selectors, (String)",");
    }

    private Element getNestedList(String listTag, ListIterator<Element> headingElementsIterator, int parentHeadingLevel, Map<String, Integer> customIDs) {
        if (!headingElementsIterator.hasNext()) {
            return null;
        }
        Element list = new Element(listTag);
        Element headingElement = headingElementsIterator.next();
        Element listItem = this.getListItemElement(headingElement, customIDs);
        int previousHeadingLevel = this.getHeadingLevel(headingElement);
        list.appendChild((Node)listItem);
        while (headingElementsIterator.hasNext()) {
            headingElement = headingElementsIterator.next();
            int currentHeadingLevel = this.getHeadingLevel(headingElement);
            if (currentHeadingLevel == previousHeadingLevel || currentHeadingLevel < previousHeadingLevel && currentHeadingLevel > parentHeadingLevel) {
                listItem = this.getListItemElement(headingElement, customIDs);
                list.appendChild((Node)listItem);
                previousHeadingLevel = currentHeadingLevel;
                continue;
            }
            if (currentHeadingLevel > previousHeadingLevel) {
                headingElementsIterator.previous();
                list.children().last().appendChild((Node)this.getNestedList(listTag, headingElementsIterator, previousHeadingLevel, customIDs));
                continue;
            }
            headingElementsIterator.previous();
            return list;
        }
        return list;
    }

    private Element getListItemElement(Element headingElement, Map<String, Integer> customIDs) {
        String id = headingElement.attr("id");
        if ("".contentEquals(id)) {
            id = headingElement.text().trim().toLowerCase().replaceAll("\\s", "-");
            customIDs.put(id, 1 + customIDs.getOrDefault(id, 0));
            id = id + (customIDs.get(id) == 1 ? "" : "-" + (customIDs.get(id) - 1));
            headingElement.attr("id", id);
        }
        Element listItem = new Element("li");
        Element anchorTag = new Element("a");
        anchorTag.attr("href", "#" + id);
        anchorTag.appendText(headingElement.text());
        listItem.appendChild((Node)anchorTag);
        return listItem;
    }

    private int getHeadingLevel(Element headingElement) {
        return headingElement.tagName().charAt(1) - 48;
    }

    private String getHeadingTagName(int level) {
        return "h" + level;
    }

    @ObjectClassDefinition(name="Core Components TableOfContentsFilter Config", description="Configuration for enabling TableOfContentsFilter")
    public static @interface Config {
        @AttributeDefinition(name="Enabled", description="Whether TableOfContentsFilter component will be activated or not")
        public boolean enabled() default false;
    }
}

