/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.servlets;

import com.adobe.cq.wcm.core.components.commons.link.LinkManager;
import com.adobe.cq.wcm.core.components.internal.LocalizationUtils;
import com.adobe.cq.wcm.core.components.internal.models.v1.PageListItemImpl;
import com.adobe.cq.wcm.core.components.models.ListItem;
import com.adobe.cq.wcm.core.components.models.Search;
import com.day.cq.search.PredicateConverter;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.SearchResult;
import com.day.cq.wcm.api.LanguageManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.msm.api.LiveRelationshipManager;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.StreamSupport;
import javax.jcr.Session;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.models.factory.ModelFactory;
import org.apache.sling.scripting.core.ScriptHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"sling.servlet.selectors=searchresults", "sling.servlet.resourceTypes=cq/Page", "sling.servlet.extensions=json", "sling.servlet.methods=GET"})
public final class SearchResultServlet
extends SlingSafeMethodsServlet {
    protected static final String DEFAULT_SELECTOR = "searchresults";
    protected static final String PARAM_FULLTEXT = "fulltext";
    protected static final String PARAM_RESULTS_OFFSET = "resultsOffset";
    private static final String NN_STRUCTURE = "structure";
    @Reference
    private transient QueryBuilder queryBuilder;
    @Reference
    private transient LanguageManager languageManager;
    @Reference
    private transient LiveRelationshipManager relationshipManager;
    @Reference
    private transient ModelFactory modelFactory;
    private BundleContext bundleContext;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        Page currentPage = Optional.ofNullable(request.getResourceResolver().adaptTo(PageManager.class)).map(pm -> pm.getContainingPage(request.getResource())).orElse(null);
        if (currentPage != null) {
            SlingBindings bindings = new SlingBindings();
            bindings.setSling((SlingScriptHelper)new ScriptHelper(this.bundleContext, null, request, response));
            request.setAttribute(SlingBindings.class.getName(), (Object)bindings);
            Search searchComponent = this.getSearchComponent(request, currentPage);
            try {
                List<ListItem> results = this.getResults(request, searchComponent, currentPage.getPageManager());
                response.setContentType("application/json");
                response.setCharacterEncoding(StandardCharsets.UTF_8.name());
                new ObjectMapper().writeValue((Writer)response.getWriter(), results);
            }
            catch (NumberFormatException e) {
                response.sendError(400);
            }
        } else {
            response.sendError(404);
        }
    }

    @NotNull
    private Search getSearchComponent(@NotNull SlingHttpServletRequest request, @NotNull Page currentPage) {
        String suffix = request.getRequestPathInfo().getSuffix();
        String relativeContentResourcePath = Optional.ofNullable(suffix).filter(path -> StringUtils.startsWith((CharSequence)path, (CharSequence)"/")).map(path -> StringUtils.substring((String)path, (int)1)).orElse(suffix);
        return Optional.ofNullable(relativeContentResourcePath).filter(StringUtils::isNotEmpty).map(rcrp -> this.getSearchComponentResourceFromPage(request.getResource(), (String)rcrp).orElse(this.getSearchComponentResourceFromTemplate(currentPage, (String)rcrp).orElse(null))).map(resource -> (Search)this.modelFactory.getModelFromWrappedRequest(request, resource, Search.class)).orElseGet(() -> new DefaultSearch(currentPage, request.getResourceResolver()));
    }

    private Optional<Resource> getSearchComponentResourceFromPage(@NotNull Resource pageResource, String relativeContentResourcePath) {
        return Optional.ofNullable(Optional.ofNullable(pageResource.getChild(relativeContentResourcePath)).orElse(this.getSearchComponentResourceFromFragments(pageResource.getChild("jcr:content"), relativeContentResourcePath).orElse(null)));
    }

    private Optional<Resource> getSearchComponentResourceFromTemplate(@NotNull Page currentPage, String relativeContentResourcePath) {
        return Optional.ofNullable(currentPage.getTemplate()).map(Template::getPath).map(arg_0 -> ((ResourceResolver)currentPage.getContentResource().getResourceResolver()).getResource(arg_0)).map(templateResource -> Optional.ofNullable(templateResource.getChild("structure/" + relativeContentResourcePath)).orElse(this.getSearchComponentResourceFromFragments((Resource)templateResource, relativeContentResourcePath).orElse(null)));
    }

    private Optional<Resource> getSearchComponentResourceFromFragments(Resource resource, String relativeContentResourcePath) {
        return Optional.ofNullable(resource).map(res -> this.getSearchComponentResourceFromFragment((Resource)res, relativeContentResourcePath).orElse(StreamSupport.stream(res.getChildren().spliterator(), false).map(child -> this.getSearchComponentResourceFromFragments((Resource)child, relativeContentResourcePath).orElse(null)).filter(Objects::nonNull).findFirst().orElse(null)));
    }

    private Optional<Resource> getSearchComponentResourceFromFragment(Resource candidate, String relativeContentResourcePath) {
        return Optional.ofNullable(candidate).map(Resource::getValueMap).map(properties -> (String)properties.get("fragmentVariationPath", String.class)).map(path -> candidate.getResourceResolver().getResource(path + "/" + relativeContentResourcePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private List<ListItem> getResults(@NotNull SlingHttpServletRequest request, @NotNull Search searchComponent, @NotNull PageManager pageManager) {
        ArrayList<ListItem> results = new ArrayList<ListItem>();
        String fulltext = request.getParameter(PARAM_FULLTEXT);
        if (fulltext == null || fulltext.length() < searchComponent.getSearchTermMinimumLength()) {
            return results;
        }
        long resultsOffset = Optional.ofNullable(request.getParameter(PARAM_RESULTS_OFFSET)).map(Long::parseLong).orElse(0L);
        HashMap<String, String> predicatesMap = new HashMap<String, String>();
        predicatesMap.put(PARAM_FULLTEXT, fulltext);
        predicatesMap.put("path", searchComponent.getSearchRootPagePath());
        predicatesMap.put("type", "cq:Page");
        PredicateGroup predicates = PredicateConverter.createPredicates(predicatesMap);
        ResourceResolver resourceResolver = request.getResource().getResourceResolver();
        Query query = this.queryBuilder.createQuery(predicates, (Session)resourceResolver.adaptTo(Session.class));
        if (searchComponent.getResultsSize() != 0) {
            query.setHitsPerPage((long)searchComponent.getResultsSize());
        }
        if (resultsOffset != 0L) {
            query.setStart(resultsOffset);
        }
        SearchResult searchResult = query.getResult();
        LinkManager linkManager = (LinkManager)request.adaptTo(LinkManager.class);
        try (ResourceResolver leakingResourceResolver = null;){
            Iterator resourceIterator = searchResult.getResources();
            while (resourceIterator.hasNext()) {
                Resource resource = (Resource)resourceIterator.next();
                if (leakingResourceResolver == null) {
                    leakingResourceResolver = resource.getResourceResolver();
                }
                Optional.of(resource).map(res -> resourceResolver.getResource(res.getPath())).map(arg_0 -> ((PageManager)pageManager).getContainingPage(arg_0)).map(page -> new PageListItemImpl(linkManager, (Page)page, searchComponent.getId(), null)).ifPresent(results::add);
            }
        }
        return results;
    }

    private final class DefaultSearch
    implements Search {
        @NotNull
        private final String searchRootPagePath;

        public DefaultSearch(@NotNull Page currentPage, ResourceResolver resourceResolver) {
            this.searchRootPagePath = Optional.ofNullable(currentPage.getContentResource()).map(arg_0 -> ((LanguageManager)SearchResultServlet.this.languageManager).getLanguageRoot(arg_0)).map(Page::getPath).map(languageRoot -> LocalizationUtils.getLocalPage(languageRoot, currentPage, resourceResolver, SearchResultServlet.this.languageManager, SearchResultServlet.this.relationshipManager).map(Page::getPath).orElse((String)languageRoot)).orElseGet(() -> ((Page)currentPage).getPath());
        }

        @Override
        @Nullable
        public String getId() {
            return null;
        }

        @Override
        public int getResultsSize() {
            return 10;
        }

        @Override
        public int getSearchTermMinimumLength() {
            return 3;
        }

        @Override
        @NotNull
        public String getSearchRootPagePath() {
            return this.searchRootPagePath;
        }
    }
}

