/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.servlets;

import org.apache.sling.commons.metrics.Counter;
import org.apache.sling.commons.metrics.MetricsService;
import org.apache.sling.commons.metrics.Timer;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AdaptiveImageServletMetrics.class})
public class AdaptiveImageServletMetrics {
    private static final String BASENAME = "com.adobe.cq.wcm.core.components.internal.servlets.AdaptiveImageServlet:";
    @Reference
    MetricsService metricsService;
    private Counter invocations;
    private Counter originalRenditionUsed;
    private Counter baseRenditionRejected;
    private Counter imageStreamed;
    private Timer requestDuration;
    private Counter imageErrors;

    @Activate
    public void activate() {
        this.invocations = this.metricsService.counter("com.adobe.cq.wcm.core.components.internal.servlets.AdaptiveImageServlet:invocations");
        this.originalRenditionUsed = this.metricsService.counter("com.adobe.cq.wcm.core.components.internal.servlets.AdaptiveImageServlet:original-rendition-used");
        this.baseRenditionRejected = this.metricsService.counter("com.adobe.cq.wcm.core.components.internal.servlets.AdaptiveImageServlet:base-rendition-rejected-because-of-size");
        this.imageStreamed = this.metricsService.counter("com.adobe.cq.wcm.core.components.internal.servlets.AdaptiveImageServlet:rendition-rendered");
        this.requestDuration = this.metricsService.timer("com.adobe.cq.wcm.core.components.internal.servlets.AdaptiveImageServlet:request-duration");
        this.imageErrors = this.metricsService.counter("com.adobe.cq.wcm.core.components.internal.servlets.AdaptiveImageServlet:image-errors");
    }

    public void markServletInvocation() {
        this.invocations.increment();
    }

    public void markOriginalRenditionUsed() {
        this.originalRenditionUsed.increment();
    }

    public void markRejectedTooLargeRendition() {
        this.baseRenditionRejected.increment();
    }

    public void markImageStreamed() {
        this.imageStreamed.increment();
    }

    public void markImageErrors() {
        this.imageErrors.increment();
    }

    public Timer.Context startDurationRecording() {
        return this.requestDuration.time();
    }
}

