/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.servlets;

import com.adobe.cq.wcm.core.components.commons.link.LinkManager;
import com.adobe.cq.wcm.core.components.internal.Utils;
import com.adobe.cq.wcm.core.components.internal.helper.image.AdaptiveImageHelper;
import com.adobe.cq.wcm.core.components.internal.resource.CoreResourceWrapper;
import com.adobe.cq.wcm.core.components.internal.servlets.AdaptiveImageServletMetrics;
import com.adobe.cq.wcm.core.components.internal.servlets.EnhancedRendition;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.RenditionPicker;
import com.day.cq.dam.api.handler.AssetHandler;
import com.day.cq.dam.api.handler.store.AssetStore;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentManager;
import com.day.cq.wcm.api.designer.Designer;
import com.day.cq.wcm.api.designer.Style;
import com.day.cq.wcm.api.policies.ContentPolicy;
import com.day.cq.wcm.api.policies.ContentPolicyManager;
import com.day.cq.wcm.commons.WCMUtils;
import com.day.cq.wcm.foundation.WCMRenditionPicker;
import com.day.image.Layer;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.metrics.Timer;
import org.apache.sling.commons.mime.MimeTypeService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdaptiveImageServlet
extends SlingSafeMethodsServlet {
    public static final String DEFAULT_SELECTOR = "img";
    public static final String CORE_DEFAULT_SELECTOR = "coreimg";
    static final int DEFAULT_RESIZE_WIDTH = 1280;
    public static final int DEFAULT_JPEG_QUALITY = 82;
    public static final int DEFAULT_MAX_SIZE = 3840;
    private static final Logger LOGGER = LoggerFactory.getLogger(AdaptiveImageServlet.class);
    private static final String DEFAULT_MIME = "image/jpeg";
    private static final String SELECTOR_QUALITY_KEY = "quality";
    private static final String SELECTOR_WIDTH_KEY = "width";
    private int defaultResizeWidth;
    private int maxInputWidth;
    private AdaptiveImageServletMetrics metrics;
    @SuppressFBWarnings(justification="This field needs to be transient")
    private transient MimeTypeService mimeTypeService;
    @SuppressFBWarnings(justification="This field needs to be transient")
    private transient AssetStore assetStore;

    public AdaptiveImageServlet(MimeTypeService mimeTypeService, AssetStore assetStore, AdaptiveImageServletMetrics metrics, int defaultResizeWidth, int maxInputWidth) {
        this.mimeTypeService = mimeTypeService;
        this.assetStore = assetStore;
        this.metrics = metrics;
        this.defaultResizeWidth = defaultResizeWidth > 0 ? defaultResizeWidth : 1280;
        this.maxInputWidth = maxInputWidth > 0 ? maxInputWidth : 3840;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        Timer.Context requestDuration = this.metrics.startDurationRecording();
        try {
            long requestLastModifiedSuffix;
            String imageName;
            this.metrics.markServletInvocation();
            RequestPathInfo requestPathInfo = request.getRequestPathInfo();
            List<String> selectorList = this.selectorToList(requestPathInfo.getSelectorString());
            String suffix = requestPathInfo.getSuffix();
            String string = imageName = StringUtils.isNotEmpty((CharSequence)suffix) ? FilenameUtils.getName((String)suffix) : "";
            if (StringUtils.isNotEmpty((CharSequence)suffix)) {
                String suffixExtension = FilenameUtils.getExtension((String)suffix);
                if (StringUtils.isNotEmpty((CharSequence)suffixExtension)) {
                    if (!suffixExtension.equals(requestPathInfo.getExtension())) {
                        LOGGER.error("The suffix part defines a different extension than the request: {}.", (Object)suffix);
                        this.metrics.markImageErrors();
                        response.sendError(404);
                        return;
                    }
                } else {
                    LOGGER.error("Invalid suffix: {}.", (Object)suffix);
                    this.metrics.markImageErrors();
                    response.sendError(404);
                    return;
                }
            }
            Resource component = request.getResource();
            ResourceResolver resourceResolver = request.getResourceResolver();
            if (StringUtils.isNotEmpty((CharSequence)suffix)) {
                Resource componentCandidate = AdaptiveImageHelper.getComponentCandidate(suffix, component);
                if (componentCandidate != null) {
                    component = componentCandidate;
                } else if (!component.isResourceType("core/wcm/components/image")) {
                    LOGGER.error("Unable to retrieve an image from this page's template.");
                    this.metrics.markImageErrors();
                    response.sendError(404);
                    return;
                }
            }
            LinkManager linkManager = (LinkManager)request.adaptTo(LinkManager.class);
            Style currentStyle = WCMUtils.getStyle((SlingHttpServletRequest)request);
            Page currentPage = Optional.ofNullable(resourceResolver.adaptTo(PageManager.class)).map(pageManager -> pageManager.getContainingPage(request.getResource())).orElse(null);
            Resource wrappedImageResourceWithInheritance = Utils.getWrappedImageResourceWithInheritance(component, linkManager, currentStyle, currentPage);
            ImageComponent imageComponent = new ImageComponent(wrappedImageResourceWithInheritance);
            if (imageComponent.source == Source.NOCONTENT || imageComponent.source == Source.NONEXISTING) {
                LOGGER.error("Either the image from {} does not have a valid file reference or the containing page does not have a valid featured image", (Object)component.getPath());
                this.metrics.markImageErrors();
                response.sendError(404);
                return;
            }
            ValueMap componentProperties = component.getValueMap();
            long lastModifiedEpoch = 0L;
            Calendar lastModifiedDate = (Calendar)componentProperties.get("jcr:lastModified", Calendar.class);
            if (lastModifiedDate == null) {
                lastModifiedDate = (Calendar)componentProperties.get("cq:lastModified", Calendar.class);
            }
            if (lastModifiedDate != null) {
                lastModifiedEpoch = lastModifiedDate.getTimeInMillis();
            }
            Asset asset = null;
            if (imageComponent.source == Source.ASSET) {
                asset = (Asset)imageComponent.imageResource.adaptTo(Asset.class);
                if (asset == null) {
                    LOGGER.error("Unable to adapt resource {} used by image {} to an asset.", (Object)imageComponent.imageResource.getPath(), (Object)component.getPath());
                    this.metrics.markImageErrors();
                    response.sendError(404);
                    return;
                }
                long assetLastModifiedEpoch = asset.getLastModified();
                if (assetLastModifiedEpoch > lastModifiedEpoch) {
                    lastModifiedEpoch = assetLastModifiedEpoch;
                }
            }
            if ((requestLastModifiedSuffix = AdaptiveImageHelper.getRequestLastModifiedSuffix(suffix)) >= 0L && requestLastModifiedSuffix != lastModifiedEpoch) {
                String redirectLocation = AdaptiveImageHelper.getRedirectLocation(request, lastModifiedEpoch);
                if (StringUtils.isNotEmpty((CharSequence)redirectLocation)) {
                    response.setStatus(302);
                    if (StringUtils.isNotEmpty((CharSequence)request.getQueryString())) {
                        redirectLocation = redirectLocation + '?' + request.getQueryString();
                    }
                    response.setHeader("Location", redirectLocation);
                    return;
                }
                LOGGER.error("Unable to determine correct redirect location.");
                this.metrics.markImageErrors();
                response.setStatus(404);
                return;
            }
            if (!this.handleIfModifiedSinceHeader(request, response, lastModifiedEpoch)) {
                Map<String, Integer> transformationMap = this.getTransformationMap(selectorList, component, request);
                Integer jpegQualityInPercentage = transformationMap.get(SELECTOR_QUALITY_KEY);
                double quality = (double)jpegQualityInPercentage.intValue() / 100.0;
                int resizeWidth = transformationMap.get(SELECTOR_WIDTH_KEY);
                String imageType = this.getImageType(requestPathInfo.getExtension());
                if (imageComponent.source == Source.FILE) {
                    this.transformAndStreamFile(response, componentProperties, resizeWidth, quality, imageComponent.imageResource, imageType, imageName);
                } else if (imageComponent.source == Source.ASSET) {
                    this.transformAndStreamAsset(response, componentProperties, resizeWidth, quality, asset, imageType, imageName);
                }
                this.metrics.markImageStreamed();
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Invalid image request", (Throwable)e);
            this.metrics.markImageErrors();
            response.sendError(404);
        }
        finally {
            requestDuration.stop();
        }
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Scanning generated code of try-with-resources")
    protected void transformAndStreamAsset(SlingHttpServletResponse response, ValueMap componentProperties, int resizeWidth, double quality, Asset asset, String imageType, String imageName) throws IOException {
        String extension = this.mimeTypeService.getExtension(imageType);
        if ("gif".equalsIgnoreCase(extension) || "svg".equalsIgnoreCase(extension)) {
            LOGGER.debug("GIF or SVG asset detected; will render the original rendition.");
            this.metrics.markOriginalRenditionUsed();
            try (InputStream is = asset.getOriginal().getStream();){
                if (is != null) {
                    this.stream(response, is, imageType, imageName);
                }
            }
            return;
        }
        int rotationAngle = this.getRotation(componentProperties);
        Rectangle rectangle = this.getCropRect(componentProperties);
        boolean flipHorizontally = (Boolean)componentProperties.get("imageFlipHorizontal", (Object)Boolean.FALSE);
        boolean flipVertically = (Boolean)componentProperties.get("imageFlipVertical", (Object)Boolean.FALSE);
        if (rotationAngle != 0 || rectangle != null || resizeWidth > 0 || flipHorizontally || flipVertically) {
            int originalWidth = this.getDimension(asset.getMetadataValue("tiff:ImageWidth"));
            int originalHeight = this.getDimension(asset.getMetadataValue("tiff:ImageLength"));
            Layer layer = null;
            boolean appliedTransformation = false;
            if (rectangle != null) {
                EnhancedRendition wcmRendition = this.getWCMRendition(asset);
                Dimension renditionDimension = wcmRendition.getDimension();
                double renditionWidth = renditionDimension != null ? renditionDimension.getWidth() : (double)originalWidth;
                double scaling = (double)originalWidth > renditionWidth ? (double)originalWidth / renditionWidth : (originalWidth > 0 ? renditionWidth / (double)originalWidth : 1.0);
                layer = this.getLayer(this.getOriginal(asset));
                if (layer != null) {
                    if (Math.abs(scaling - 1.0) != 0.0) {
                        Rectangle scaledRectangle = new Rectangle((int)((double)rectangle.x * scaling), (int)((double)rectangle.y * scaling), (int)(rectangle.getWidth() * scaling), (int)(rectangle.getHeight() * scaling));
                        layer.crop((Rectangle2D)scaledRectangle);
                    } else {
                        layer.crop((Rectangle2D)rectangle);
                    }
                    appliedTransformation = true;
                }
            }
            if (rotationAngle != 0) {
                if (layer == null) {
                    layer = this.getLayer(this.getBestRendition(asset, resizeWidth, imageType));
                }
                if (layer != null) {
                    layer.rotate((double)rotationAngle);
                    LOGGER.debug("Applied rotation transformation ({} degrees).", (Object)rotationAngle);
                    appliedTransformation = true;
                }
            }
            if (flipHorizontally) {
                if (layer == null) {
                    layer = this.getLayer(this.getBestRendition(asset, resizeWidth, imageType));
                }
                if (layer != null) {
                    layer.flipHorizontally();
                    LOGGER.debug("Flipped image horizontally.");
                    appliedTransformation = true;
                }
            }
            if (flipVertically) {
                if (layer == null) {
                    layer = this.getLayer(this.getBestRendition(asset, resizeWidth, imageType));
                }
                if (layer != null) {
                    layer.flipVertically();
                    LOGGER.debug("Flipped image vertically.");
                    appliedTransformation = true;
                }
            }
            if (!appliedTransformation) {
                EnhancedRendition rendition = this.getBestRendition(asset, resizeWidth, imageType);
                Dimension dimension = rendition.getDimension();
                if (dimension != null) {
                    originalHeight = Math.round((float)originalHeight * ((float)dimension.width / (float)originalWidth));
                    originalWidth = dimension.width;
                }
                if (originalWidth > resizeWidth) {
                    int resizeHeight = this.calculateResizeHeight(originalWidth, originalHeight, resizeWidth);
                    if (resizeHeight > 0 && resizeHeight != originalHeight) {
                        layer = this.getLayer(rendition);
                        if (layer != null) {
                            if (layer.getBackground().getTransparency() != 1 && ("jpg".equalsIgnoreCase(extension) || "jpeg".equalsIgnoreCase(extension))) {
                                LOGGER.debug("Adding default (white) background to a transparent PNG: {}/{}", (Object)asset.getPath(), (Object)rendition.getName());
                                layer.setBackground((Paint)Color.white);
                            }
                            layer.resize(resizeWidth, resizeHeight);
                            response.setContentType(imageType);
                            LOGGER.debug("Resizing asset {}/{} to requested width of {}px; rendering.", new Object[]{asset.getPath(), rendition.getName(), resizeWidth});
                            layer.write(imageType, quality, (OutputStream)response.getOutputStream());
                        } else {
                            this.streamOrConvert(response, rendition, imageType, imageName, resizeWidth, quality);
                        }
                    } else {
                        this.streamOrConvert(response, rendition, imageType, imageName, resizeWidth, quality);
                    }
                } else {
                    this.streamOrConvert(response, rendition, imageType, imageName, resizeWidth, quality);
                }
            } else {
                this.resizeAndStreamLayer(response, layer, imageType, resizeWidth, quality);
            }
        } else {
            LOGGER.debug("No need to perform any processing on asset {}; rendering.", (Object)asset.getPath());
            try (InputStream is = this.getOriginal(asset).getStream();){
                if (is != null) {
                    this.stream(response, is, imageType, imageName);
                }
            }
        }
    }

    private void transformAndStreamFile(SlingHttpServletResponse response, ValueMap componentProperties, int resizeWidth, double quality, Resource imageFile, String imageType, String imageName) throws IOException {
        try (InputStream is = (InputStream)imageFile.adaptTo(InputStream.class);){
            if ("gif".equalsIgnoreCase(this.mimeTypeService.getExtension(imageType)) || "svg".equalsIgnoreCase(this.mimeTypeService.getExtension(imageType))) {
                LOGGER.debug("GIF or SVG file detected; will render the original file.");
                if (is != null) {
                    this.stream(response, is, imageType, imageName);
                }
                return;
            }
            int rotationAngle = this.getRotation(componentProperties);
            Rectangle rectangle = this.getCropRect(componentProperties);
            boolean flipHorizontally = (Boolean)componentProperties.get("imageFlipHorizontal", (Object)Boolean.FALSE);
            boolean flipVertically = (Boolean)componentProperties.get("imageFlipVertical", (Object)Boolean.FALSE);
            if (is != null) {
                if (rotationAngle != 0 || rectangle != null || resizeWidth > 0 || flipHorizontally || flipVertically) {
                    Layer layer = new Layer(is);
                    if (rectangle != null) {
                        layer.crop((Rectangle2D)rectangle);
                        LOGGER.debug("Applied cropping transformation.");
                    }
                    if (rotationAngle != 0) {
                        layer.rotate((double)rotationAngle);
                        LOGGER.debug("Applied rotation transformation ({} degrees).", (Object)rotationAngle);
                    }
                    if (flipHorizontally) {
                        layer.flipHorizontally();
                    }
                    if (flipVertically) {
                        layer.flipVertically();
                    }
                    if (layer.getBackground().getTransparency() != 1 && ("jpg".equalsIgnoreCase(this.mimeTypeService.getExtension(imageType)) || "jpeg".equalsIgnoreCase(this.mimeTypeService.getExtension(imageType)))) {
                        LOGGER.debug("Adding default (white) background to a transparent JPG: {}", (Object)imageFile.getPath());
                        layer.setBackground((Paint)Color.white);
                    }
                    this.resizeAndStreamLayer(response, layer, imageType, resizeWidth, quality);
                } else {
                    LOGGER.debug("No need to perform any processing on file {}; rendering.", (Object)imageFile.getPath());
                    this.stream(response, is, imageType, imageName);
                }
            }
        }
    }

    protected void resizeAndStreamLayer(SlingHttpServletResponse response, Layer layer, String imageType, int resizeWidth, double quality) throws IOException {
        int height;
        int width = layer.getWidth();
        int resizeHeight = this.calculateResizeHeight(width, height = layer.getHeight(), resizeWidth);
        if (resizeHeight > 0) {
            layer.resize(resizeWidth, resizeHeight);
            response.setContentType(imageType);
            LOGGER.debug("Resizing processed (cropped and/or rotated) layer from its current width of {}px to {}px.", (Object)width, (Object)resizeWidth);
            layer.write(imageType, quality, (OutputStream)response.getOutputStream());
        } else {
            response.setContentType(imageType);
            LOGGER.debug("No need to resize processed (cropped and/or rotated) layer since it would lead to upscaling; rendering.");
            layer.write(imageType, quality, (OutputStream)response.getOutputStream());
        }
    }

    @Nullable
    private Layer getLayer(@NotNull EnhancedRendition rendition) {
        AssetHandler assetHandler = this.assetStore.getAssetHandler(rendition.getMimeType());
        try {
            BufferedImage image = assetHandler.getImage(rendition.getRendition());
            if (image != null) {
                return new Layer(image);
            }
        }
        catch (IOException ioex) {
            LOGGER.debug("Unable to handle rendition " + rendition.getPath(), (Throwable)ioex);
        }
        return null;
    }

    @NotNull
    private EnhancedRendition getWCMRendition(@NotNull Asset asset) {
        return new EnhancedRendition(asset.getRendition((RenditionPicker)new WCMRenditionPicker()));
    }

    @NotNull
    protected EnhancedRendition getBestRendition(@NotNull Asset asset, int width, @NotNull String mimeType) throws IOException {
        EnhancedRendition bestRendition;
        TreeSet<EnhancedRendition> matchingRenditions = new TreeSet<EnhancedRendition>(Comparator.comparingInt(o -> o.getDimension() == null ? 0 : o.getDimension().width));
        TreeSet<EnhancedRendition> nonMatchingRenditions = new TreeSet<EnhancedRendition>(Comparator.comparingInt(o -> o.getDimension() == null ? 0 : o.getDimension().width));
        for (Rendition rendition : asset.getRenditions()) {
            EnhancedRendition enhancedRendition = new EnhancedRendition(rendition);
            if (mimeType.equals(rendition.getMimeType())) {
                matchingRenditions.add(enhancedRendition);
                continue;
            }
            nonMatchingRenditions.add(enhancedRendition);
        }
        if (!matchingRenditions.isEmpty()) {
            bestRendition = this.findBestRendition(matchingRenditions, width);
            if (bestRendition == null) {
                bestRendition = mimeType.equals(asset.getMimeType()) ? this.getOriginal(asset) : (EnhancedRendition)matchingRenditions.last();
            }
        } else {
            bestRendition = this.findBestRendition(nonMatchingRenditions, width);
            if (bestRendition == null) {
                return this.getOriginal(asset);
            }
        }
        return this.filter(bestRendition);
    }

    @Nullable
    private EnhancedRendition findBestRendition(SortedSet<EnhancedRendition> renditions, int width) {
        for (EnhancedRendition rendition : renditions) {
            Dimension dimension = rendition.getDimension();
            if (dimension == null || !(dimension.getWidth() >= (double)width)) continue;
            if (StringUtils.equals((CharSequence)rendition.getPath(), (CharSequence)rendition.getAsset().getOriginal().getPath())) {
                this.metrics.markOriginalRenditionUsed();
            }
            return rendition;
        }
        return null;
    }

    @NotNull
    private EnhancedRendition getOriginal(@NotNull Asset asset) throws IOException {
        EnhancedRendition original = new EnhancedRendition(asset.getOriginal());
        EnhancedRendition filtered = this.filter(original);
        this.metrics.markOriginalRenditionUsed();
        return filtered;
    }

    @NotNull
    private EnhancedRendition filter(@NotNull EnhancedRendition rendition) throws IOException {
        Dimension dimension = rendition.getDimension();
        if (dimension != null && dimension.getWidth() <= (double)this.maxInputWidth) {
            return rendition;
        }
        this.metrics.markRejectedTooLargeRendition();
        throw new IOException(String.format("Cannot process rendition %s due to size %s", rendition.getName(), rendition.getDimension()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Scanning generated code of try-with-resources")
    private void streamOrConvert(@NotNull SlingHttpServletResponse response, @NotNull EnhancedRendition rendition, @NotNull String imageType, String imageName, int resizeWidth, double quality) throws IOException {
        Dimension dimension = rendition.getDimension();
        if (rendition.getMimeType().equals(imageType)) {
            LOGGER.debug("Found rendition {}/{} has a width of {}px and does not require a resize for requested width of {}px", new Object[]{rendition.getAsset().getPath(), rendition.getName(), dimension != null ? Double.valueOf(dimension.getWidth()) : null, resizeWidth});
            try (InputStream is = rendition.getStream();){
                if (is == null) return;
                this.stream(response, is, imageType, imageName);
                return;
            }
        } else {
            Layer layer = this.getLayer(rendition);
            if (layer == null) {
                LOGGER.warn("Found rendition {}/{} has a width of {}px and does not require a resize for requested width of {}px but the rendition is not of the requested type {}, cannot convert so serving as is", new Object[]{rendition.getAsset().getPath(), rendition.getName(), dimension != null ? Double.valueOf(dimension.getWidth()) : null, resizeWidth, imageType});
                try (InputStream is = rendition.getStream();){
                    if (is == null) return;
                    this.stream(response, is, rendition.getMimeType(), imageName);
                    return;
                }
            } else {
                LOGGER.debug("Found rendition {}/{} has a width of {}px and does not require a resize for requested width of {}px but the rendition is not of the requested type {}, need to convert", new Object[]{rendition.getAsset().getPath(), rendition.getName(), dimension != null ? Double.valueOf(dimension.getWidth()) : null, resizeWidth, imageType});
                this.resizeAndStreamLayer(response, layer, imageType, 0, quality);
            }
        }
    }

    private void stream(@NotNull SlingHttpServletResponse response, @NotNull InputStream inputStream, @NotNull String contentType, String imageName) throws IOException {
        response.setContentType(contentType);
        String extension = this.mimeTypeService.getExtension(contentType);
        String disposition = "svg".equalsIgnoreCase(extension) ? "attachment" : "inline";
        response.setHeader("Content-Disposition", disposition + "; filename=" + URLEncoder.encode(imageName, "UTF-8"));
        IOUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
    }

    private Rectangle getCropRect(@NotNull ValueMap properties) {
        String csv = (String)properties.get("imageCrop", String.class);
        if (StringUtils.isNotEmpty((CharSequence)csv)) {
            try {
                int ratio = csv.indexOf(47);
                if (ratio >= 0) {
                    csv = csv.substring(0, ratio);
                }
                String[] coords = csv.split(",");
                int x1 = Integer.parseInt(coords[0]);
                int y1 = Integer.parseInt(coords[1]);
                int x2 = Integer.parseInt(coords[2]);
                int y2 = Integer.parseInt(coords[3]);
                return new Rectangle(x1, y1, x2 - x1, y2 - y1);
            }
            catch (RuntimeException e) {
                LOGGER.warn(String.format("Invalid cropping rectangle %s.", csv), (Throwable)e);
            }
        }
        return null;
    }

    private int getRotation(@NotNull ValueMap properties) {
        String rotationString = (String)properties.get("imageRotate", String.class);
        if (rotationString != null) {
            try {
                return Integer.parseInt(rotationString);
            }
            catch (NumberFormatException e) {
                LOGGER.warn(String.format("Invalid rotation value %s.", rotationString), (Throwable)e);
            }
        }
        return 0;
    }

    private int getDimension(String stringValue) {
        try {
            return Integer.parseInt(stringValue);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private int calculateResizeHeight(int assetWidth, int assetHeight, int resizeWidth) {
        if (assetWidth > 0 && assetHeight > 0 && resizeWidth < assetWidth) {
            double scaleFactor = (double)resizeWidth / (double)assetWidth;
            return (int)(scaleFactor * (double)assetHeight);
        }
        if (assetWidth > 0 && assetHeight > 0 && resizeWidth == assetWidth) {
            return assetHeight;
        }
        return 0;
    }

    private boolean handleIfModifiedSinceHeader(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, long lastModified) {
        if (lastModified > 0L) {
            long ifModifiedSince = request.getDateHeader("If-Modified-Since") / 1000L;
            if (lastModified / 1000L <= ifModifiedSince) {
                response.setStatus(304);
                LOGGER.debug("If-Modified-Since header was present in the request. The resource was not changed, therefore replying with a 304 status code.");
                return true;
            }
            response.setDateHeader("Last-Modified", lastModified);
        }
        return false;
    }

    private String getImageType(String ext) {
        if (ext == null) {
            return DEFAULT_MIME;
        }
        if ("tiff".equalsIgnoreCase(ext) || "tif".equalsIgnoreCase(ext)) {
            return DEFAULT_MIME;
        }
        return this.mimeTypeService.getMimeType(ext);
    }

    @Nullable
    private ContentPolicy getContentPolicy(@NotNull Resource imageResource, @NotNull SlingHttpServletRequest request) {
        ContentPolicyManager policyManager;
        ContentPolicy contentPolicy = null;
        ResourceResolver resourceResolver = request.getResourceResolver();
        if (request.getResource().isResourceType("core/wcm/components/image")) {
            imageResource = request.getResource();
        }
        if ((policyManager = (ContentPolicyManager)resourceResolver.adaptTo(ContentPolicyManager.class)) != null) {
            Component component;
            ComponentManager componentManager = (ComponentManager)resourceResolver.adaptTo(ComponentManager.class);
            if (componentManager != null && (component = componentManager.getComponentOfResource(imageResource)) != null && component.getProperties() != null) {
                Component teaserComponent;
                String delegatingResourceType = (String)component.getProperties().get("teaserDelegate", String.class);
                if (StringUtils.isNotEmpty((CharSequence)delegatingResourceType) && (teaserComponent = componentManager.getComponentOfResource(imageResource = new CoreResourceWrapper((Resource)imageResource, delegatingResourceType))) != null) {
                    component = teaserComponent;
                }
                if (StringUtils.isNotEmpty((CharSequence)(delegatingResourceType = (String)component.getProperties().get("imageDelegate", String.class)))) {
                    imageResource = new CoreResourceWrapper((Resource)imageResource, delegatingResourceType);
                }
            }
            contentPolicy = policyManager.getPolicy(imageResource, request);
        } else {
            LOGGER.warn("Could not get policy manager from resource resolver!");
        }
        return contentPolicy;
    }

    private Designer getDesigner(@NotNull Resource imageResource) {
        ResourceResolver resourceResolver = imageResource.getResourceResolver();
        return (Designer)resourceResolver.adaptTo(Designer.class);
    }

    private List<String> selectorToList(String selector) throws IllegalArgumentException {
        if (StringUtils.isEmpty((CharSequence)selector)) {
            throw new IllegalArgumentException("Expected 1, 2 or 3 selectors instead got empty selector");
        }
        ArrayList selectorList = Lists.newArrayList((Iterable)Splitter.on((char)'.').omitEmptyStrings().trimResults().split((CharSequence)selector));
        if (selectorList.size() > 3) {
            throw new IllegalArgumentException("Expected 1, 2 or 3 selectors, instead got: " + selectorList.size());
        }
        return selectorList;
    }

    private Map<String, Integer> getTransformationMap(List<String> selectorList, Resource component, @NotNull SlingHttpServletRequest request) throws IllegalArgumentException {
        int width;
        HashMap<String, Integer> selectorParameterMap = new HashMap<String, Integer>();
        int n = width = this.getResizeWidth(component, request) > 0 ? this.getResizeWidth(component, request) : this.defaultResizeWidth;
        if (selectorList.size() > 1) {
            String widthString = selectorList.size() > 2 ? selectorList.get(2) : selectorList.get(1);
            try {
                width = Integer.parseInt(widthString);
                if (width <= 0) {
                    throw new IllegalArgumentException();
                }
                List<Integer> allowedRenditionWidths = this.getAllowedRenditionWidths(component, request);
                if (!allowedRenditionWidths.contains(width)) {
                    throw new IllegalArgumentException("The requested width is not allowed in the content policy or no default");
                }
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Third selector must contain a valid width information (selector > 0)");
            }
        }
        selectorParameterMap.put(SELECTOR_WIDTH_KEY, width);
        int quality = 82;
        if (selectorList.size() > 2) {
            String qualityString = selectorList.get(1);
            try {
                int qualityPercentage = Integer.parseInt(qualityString);
                if (qualityPercentage <= 0 || qualityPercentage > 100) {
                    throw new IllegalArgumentException();
                }
                Integer allowedJpegQuality = this.getAllowedJpegQuality(component, request);
                if (qualityPercentage != allowedJpegQuality) {
                    throw new IllegalArgumentException("The requested quality is not allowed in the content policy or no default");
                }
                quality = qualityPercentage;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Second selector must be a valid quality in percentage (100 <= selector > 0)");
            }
        }
        selectorParameterMap.put(SELECTOR_QUALITY_KEY, quality);
        return selectorParameterMap;
    }

    List<Integer> getAllowedRenditionWidths(@NotNull Resource imageResource, @NotNull SlingHttpServletRequest request) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        ContentPolicy contentPolicy = this.getContentPolicy(imageResource, request);
        ValueMap properties = null;
        if (contentPolicy != null) {
            properties = contentPolicy.getProperties();
        } else {
            Designer designer = this.getDesigner(imageResource);
            if (designer != null) {
                properties = designer.getStyle(imageResource);
            }
        }
        if (properties != null) {
            String[] allowedRenditionWidths;
            for (String width : allowedRenditionWidths = (String[])properties.get("allowedRenditionWidths", (Object)new String[0])) {
                try {
                    list.add(Integer.parseInt(width));
                }
                catch (NumberFormatException e) {
                    LOGGER.warn("One of the configured widths ({}) is not a valid Integer.", (Object)width);
                    return list;
                }
            }
        }
        if (list.isEmpty()) {
            int width = this.getResizeWidth(imageResource, request) > 0 ? this.getResizeWidth(imageResource, request) : this.defaultResizeWidth;
            list.add(width);
        }
        return list;
    }

    Integer getAllowedJpegQuality(@NotNull Resource imageResource, @NotNull SlingHttpServletRequest request) {
        Integer allowedJpegQuality = 82;
        ContentPolicy contentPolicy = this.getContentPolicy(imageResource, request);
        if (contentPolicy != null) {
            allowedJpegQuality = (Integer)contentPolicy.getProperties().get("jpegQuality", (Object)82);
        } else {
            Designer designer = this.getDesigner(imageResource);
            if (designer != null) {
                allowedJpegQuality = (Integer)designer.getStyle(imageResource).get("jpegQuality", (Object)82);
            }
        }
        return allowedJpegQuality;
    }

    private int getResizeWidth(@NotNull Resource imageResource, @NotNull SlingHttpServletRequest request) {
        int allowedResizeWidth = 0;
        ContentPolicy contentPolicy = this.getContentPolicy(imageResource, request);
        if (contentPolicy != null) {
            allowedResizeWidth = (Integer)contentPolicy.getProperties().get("resizeWidth", (Object)0);
        }
        return allowedResizeWidth;
    }

    private static class ImageComponent {
        Source source = Source.NONEXISTING;
        Resource imageResource;

        ImageComponent(@NotNull Resource component) {
            Resource jcrContent;
            String fileReference = (String)component.getValueMap().get("fileReference", String.class);
            Resource childFileNode = component.getChild("file");
            if (StringUtils.isEmpty((CharSequence)fileReference) && childFileNode == null) {
                this.source = Source.NOCONTENT;
            } else if (StringUtils.isNotEmpty((CharSequence)fileReference)) {
                this.imageResource = component.getResourceResolver().getResource(fileReference);
                if (this.imageResource != null) {
                    this.source = Source.ASSET;
                }
            } else if (childFileNode != null && "nt:file".equals(childFileNode.getResourceType()) && (jcrContent = childFileNode.getChild("jcr:content")) != null && jcrContent.getValueMap().containsKey((Object)"jcr:data")) {
                this.imageResource = childFileNode;
                this.source = Source.FILE;
            }
        }
    }

    private static enum Source {
        ASSET,
        FILE,
        NOCONTENT,
        NONEXISTING;

    }
}

