/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.services.seo;

import com.adobe.aem.wcm.seo.localization.SiteRootSelectionStrategy;
import com.adobe.cq.wcm.core.components.internal.Utils;
import com.adobe.cq.wcm.core.components.internal.models.v1.ExperienceFragmentDataImpl;
import com.day.cq.wcm.api.LanguageManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.TemplatedResource;
import com.day.cq.wcm.msm.api.LiveRelationshipManager;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.ranking:Integer=100"}, service={SiteRootSelectionStrategy.class})
public class LanguageNavigationSiteRootSelectionStrategy
implements SiteRootSelectionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(LanguageNavigationSiteRootSelectionStrategy.class);
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY, target="(objectClass=*DefaultSiteRootSelectionStrategy)")
    private SiteRootSelectionStrategy defaultSelectionStrategy;
    @Reference
    private LanguageManager languageManager;
    @Reference
    private LiveRelationshipManager liveRelationshipManager;
    private final Cache<Page, Optional<Resource>> languageNavigationCache = CacheBuilder.newBuilder().weakKeys().build();

    @Nullable
    public Page getSiteRoot(@NotNull Page page) {
        return this.findLanguageNavigation(page).map(languageNavigation -> Utils.getPropertyOrStyle(languageNavigation, "navigationRoot", String.class)).map(siteRoot -> page.getPageManager().getPage(siteRoot)).orElseGet(() -> this.defaultSelectionStrategy != null ? this.defaultSelectionStrategy.getSiteRoot(page) : null);
    }

    public int getStructuralDepth(@NotNull Page page) {
        return this.findLanguageNavigation(page).map(languageNavigation -> Utils.getPropertyOrStyle(languageNavigation, "structureDepth", Integer.class)).orElseGet(() -> this.defaultSelectionStrategy != null ? this.defaultSelectionStrategy.getStructuralDepth(page) : 1);
    }

    private Optional<Resource> findLanguageNavigation(Page page) {
        try {
            return (Optional)this.languageNavigationCache.get((Object)page, () -> this.findLanguageNavigation(page.getContentResource(), page));
        }
        catch (ExecutionException ex) {
            LOG.warn("Failed to find language navigation", (Throwable)ex);
            return Optional.empty();
        }
    }

    private Optional<Resource> findLanguageNavigation(Resource contentResource, Page containingPage) {
        Resource templatedResource;
        Resource resource2 = templatedResource = contentResource != null ? (Resource)contentResource.adaptTo(TemplatedResource.class) : null;
        if (templatedResource != null) {
            contentResource = templatedResource;
        }
        return this.findFirst(contentResource, resource -> resource.isResourceType("core/wcm/components/languagenavigation/v1/languagenavigation") || resource.isResourceType("core/wcm/components/languagenavigation/v2/languagenavigation"), containingPage);
    }

    private Optional<Resource> findFirst(Resource resource, Predicate<Resource> condition, Page containingPage) {
        if (resource == null) {
            return Optional.empty();
        }
        if (condition.test(resource)) {
            return Optional.of(resource);
        }
        if (resource.isResourceType("core/wcm/components/experiencefragment/v1/experiencefragment") || resource.isResourceType("core/wcm/components/experiencefragment/v2/experiencefragment")) {
            return Optional.ofNullable(resource.adaptTo(ExperienceFragmentDataImpl.class)).map(ExperienceFragmentDataImpl::getLocalizedFragmentVariationPath).map(xfPath -> resource.getResourceResolver().getResource(xfPath)).flatMap(xfResource -> this.findFirst((Resource)xfResource, condition, containingPage));
        }
        for (Resource child : resource.getChildren()) {
            Optional<Resource> result = this.findFirst(child, condition, containingPage);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }
}

