/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.resource;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.annotations.Exporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Exporter(name="jackson", extensions={"json"})
public class CoreResourceWrapper
extends ResourceWrapper {
    private final ValueMap valueMap;
    private final String overriddenResourceType;
    private final Map<String, Resource> overriddenChildren;

    public CoreResourceWrapper(@NotNull Resource resource, @NotNull String overriddenResourceType) {
        this(resource, overriddenResourceType, null, null, null);
    }

    public CoreResourceWrapper(@NotNull Resource resource, @NotNull String overriddenResourceType, @Nullable List<String> hiddenProperties, @Nullable Map<String, Object> overriddenProperties) {
        this(resource, overriddenResourceType, hiddenProperties, overriddenProperties, null);
    }

    public CoreResourceWrapper(@NotNull Resource resource, @NotNull String overriddenResourceType, @Nullable List<String> hiddenProperties, @Nullable Map<String, Object> overriddenProperties, @Nullable Map<String, Resource> overriddenChildren) {
        super(resource);
        if (StringUtils.isEmpty((CharSequence)overriddenResourceType)) {
            throw new IllegalArgumentException("The " + CoreResourceWrapper.class.getName() + " needs to override the resource type of the wrapped resource, but the resourceType argument was null or empty.");
        }
        this.overriddenResourceType = overriddenResourceType;
        this.overriddenChildren = overriddenChildren;
        HashMap<String, Object> properties = new HashMap<String, Object>((Map<String, Object>)resource.getValueMap());
        properties.put("sling:resourceType", overriddenResourceType);
        if (overriddenProperties != null) {
            properties.putAll(overriddenProperties);
        }
        if (hiddenProperties != null) {
            for (String property : hiddenProperties) {
                properties.remove(property);
            }
        }
        this.valueMap = new ValueMapDecorator(Collections.unmodifiableMap(properties));
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == ValueMap.class) {
            return (AdapterType)this.valueMap;
        }
        return (AdapterType)super.adaptTo(type);
    }

    @NotNull
    public ValueMap getValueMap() {
        return this.valueMap;
    }

    @Nullable
    public Resource getChild(String relPath) {
        if (this.overriddenChildren != null && this.overriddenChildren.containsKey(relPath)) {
            return this.overriddenChildren.get(relPath);
        }
        return super.getChild(relPath);
    }

    @NotNull
    public String getResourceType() {
        return this.overriddenResourceType;
    }

    public boolean isResourceType(String resourceType) {
        return this.getResourceResolver().isResourceType((Resource)this, resourceType);
    }
}

