/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v3;

import com.adobe.cq.ui.wcm.commons.config.NextGenDynamicMediaConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NextGenDMImageURIBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(NextGenDMImageURIBuilder.class);
    private static final String PATH_PLACEHOLDER_ASSET_ID = "{asset-id}";
    private static final String PATH_PLACEHOLDER_SEO_NAME = "{seo-name}";
    private static final String PATH_PLACEHOLDER_FORMAT = "{format}";
    private static final String DEFAULT_NGDM_ASSET_EXTENSION = "jpg";
    private NextGenDynamicMediaConfig config;
    private String fileReference;
    private String smartCropAspectRatio;
    private int width = 640;
    private int height;
    private boolean preferWebp = true;

    public NextGenDMImageURIBuilder(NextGenDynamicMediaConfig config, String fileReference) {
        this.config = config;
        this.fileReference = fileReference;
    }

    public NextGenDMImageURIBuilder withSmartCrop(String smartCropAspectRatio) {
        this.smartCropAspectRatio = smartCropAspectRatio;
        return this;
    }

    public NextGenDMImageURIBuilder withWidth(int width) {
        this.width = width;
        return this;
    }

    public NextGenDMImageURIBuilder withHeight(int height) {
        this.height = height;
        return this;
    }

    public NextGenDMImageURIBuilder withPreferWebp(boolean preferWebp) {
        this.preferWebp = preferWebp;
        return this;
    }

    public String build() {
        if (StringUtils.isNotEmpty((CharSequence)this.fileReference) && this.config != null) {
            Scanner scanner = new Scanner(this.fileReference);
            scanner.useDelimiter("/");
            String assetId = scanner.next();
            scanner = new Scanner(scanner.next());
            scanner.useDelimiter("\\.");
            String assetName = scanner.hasNext() ? scanner.next() : assetId;
            String assetExtension = scanner.hasNext() ? scanner.next() : DEFAULT_NGDM_ASSET_EXTENSION;
            String imageDeliveryBasePath = this.config.getImageDeliveryBasePath();
            String imageDeliveryPath = imageDeliveryBasePath.replace(PATH_PLACEHOLDER_ASSET_ID, assetId);
            imageDeliveryPath = imageDeliveryPath.replace(PATH_PLACEHOLDER_SEO_NAME, assetName);
            imageDeliveryPath = imageDeliveryPath.replace(PATH_PLACEHOLDER_FORMAT, assetExtension);
            String repositoryId = this.config.getRepositoryId();
            StringBuilder uriBuilder = new StringBuilder("https://" + repositoryId + imageDeliveryPath);
            HashMap<String, String> params = new HashMap<String, String>();
            if (this.width > 0) {
                params.put("width", Integer.toString(this.width));
            }
            if (this.height > 0) {
                params.put("height", Integer.toString(this.height));
            }
            if (this.preferWebp) {
                params.put("preferwebp", "true");
            }
            if (StringUtils.isNotEmpty((CharSequence)this.smartCropAspectRatio)) {
                if (this.isValidSmartCrop(this.smartCropAspectRatio)) {
                    params.put("crop", String.format("%s,smart", this.smartCropAspectRatio));
                } else {
                    LOGGER.info("Invalid smartCrop value at {}", (Object)this.smartCropAspectRatio);
                }
            }
            if (params.size() > 0) {
                uriBuilder.append("?");
                for (Map.Entry entry : params.entrySet()) {
                    uriBuilder.append((String)entry.getKey() + "=" + (String)entry.getValue());
                    uriBuilder.append("&");
                }
                uriBuilder.deleteCharAt(uriBuilder.length() - 1);
            }
            return uriBuilder.toString();
        }
        LOGGER.info("Invalid fileReference or NGDMConfig. fileReference = {}", (Object)this.fileReference);
        return null;
    }

    private boolean isValidSmartCrop(String smartCropStr) {
        String[] crops = smartCropStr.split(":");
        if (crops.length == 2) {
            try {
                Integer.parseInt(crops[0]);
                Integer.parseInt(crops[1]);
                return true;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        return false;
    }
}

