/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v3;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.ui.wcm.commons.config.NextGenDynamicMediaConfig;
import com.adobe.cq.wcm.core.components.commons.link.Link;
import com.adobe.cq.wcm.core.components.internal.Utils;
import com.adobe.cq.wcm.core.components.internal.helper.image.AssetDeliveryHelper;
import com.adobe.cq.wcm.core.components.internal.models.v2.ImageAreaImpl;
import com.adobe.cq.wcm.core.components.internal.models.v3.NextGenDMImageURIBuilder;
import com.adobe.cq.wcm.core.components.internal.servlets.EnhancedRendition;
import com.adobe.cq.wcm.core.components.models.Image;
import com.adobe.cq.wcm.core.components.models.ImageArea;
import com.day.cq.dam.api.Asset;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.awt.Dimension;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Image.class, ComponentExporter.class}, resourceType={"core/wcm/components/image/v3/image"})
@Exporter(name="jackson", extensions={"json"})
public class ImageImpl
extends com.adobe.cq.wcm.core.components.internal.models.v2.ImageImpl
implements Image {
    public static final String RESOURCE_TYPE = "core/wcm/components/image/v3/image";
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageImpl.class);
    private static final String URI_WIDTH_PLACEHOLDER_ENCODED = "%7B.width%7D";
    private static final String URI_WIDTH_PLACEHOLDER = "{.width}";
    private static final String EMPTY_PIXEL = "data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==";
    static final int DEFAULT_NGDM_ASSET_WIDTH = 640;
    @Inject
    @Optional
    private NextGenDynamicMediaConfig nextGenDynamicMediaConfig;
    private boolean imageLinkHidden = false;
    private String srcSet = "";
    private Map<String, String> srcSetWithMimeType = Collections.EMPTY_MAP;
    private String sizes;
    private Dimension dimension;
    private boolean ngdmImage = false;

    @Override
    @PostConstruct
    protected void initModel() {
        if (this.isNgdmSupportAvailable()) {
            this.initNextGenerationDynamicMedia();
        }
        super.initModel();
        if (this.hasContent) {
            this.disableLazyLoading = (Boolean)this.currentStyle.get("disableLazyLoading", (Object)false);
            this.imageLinkHidden = (Boolean)this.properties.get("imageLinkHidden", (Object)this.imageLinkHidden);
            this.sizes = String.join((CharSequence)", ", (CharSequence[])this.currentStyle.get("sizes", (Object)new String[0]));
            this.disableLazyLoading = (Boolean)this.properties.get("disableLazyLoading", this.currentStyle.get("disableLazyLoading", (Object)false));
        }
    }

    @Override
    @Nullable
    public Link getImageLink() {
        return this.imageLinkHidden || this.link != null && !this.link.isValid() ? null : this.link;
    }

    @Override
    @JsonIgnore
    @Deprecated
    public String getLink() {
        return super.getLink();
    }

    @Override
    protected ImageArea newImageArea(String shape, String coordinates, String relativeCoordinates, @NotNull Link link, String alt) {
        return new ImageAreaImpl(shape, coordinates, relativeCoordinates, link, alt);
    }

    @Override
    public String getSrcset() {
        if (!StringUtils.isEmpty((CharSequence)this.srcSet)) {
            return this.srcSet;
        }
        if (this.useAssetDelivery) {
            this.srcSet = AssetDeliveryHelper.getSrcSet(this.assetDelivery, this.resource, this.imageName, this.extension, this.smartSizes, this.jpegQuality);
            if (!StringUtils.isEmpty((CharSequence)this.srcSet)) {
                return this.srcSet;
            }
        }
        int[] widthsArray = this.getWidths();
        String srcUritemplate = this.getSrcUriTemplate();
        Object[] srcsetArray = new String[widthsArray.length];
        if (widthsArray.length > 0 && srcUritemplate != null && (srcUritemplate = StringUtils.replace((String)this.srcUriTemplate, (String)URI_WIDTH_PLACEHOLDER_ENCODED, (String)URI_WIDTH_PLACEHOLDER)).contains(URI_WIDTH_PLACEHOLDER)) {
            if (this.dmImage && StringUtils.equals((CharSequence)this.smartCropRendition, (CharSequence)"SmartCrop:Auto")) {
                this.srcSet = EMPTY_PIXEL;
            } else {
                for (int i = 0; i < widthsArray.length; ++i) {
                    srcsetArray[i] = srcUritemplate.contains("={.width}") ? srcUritemplate.replace(URI_WIDTH_PLACEHOLDER, String.format("%s", widthsArray[i])) + " " + widthsArray[i] + "w" : srcUritemplate.replace(URI_WIDTH_PLACEHOLDER, String.format(".%s", widthsArray[i])) + " " + widthsArray[i] + "w";
                }
                this.srcSet = StringUtils.join((Object[])srcsetArray, (char)',');
            }
            return this.srcSet;
        }
        return null;
    }

    @Override
    @Nullable
    public String getSizes() {
        return this.sizes;
    }

    @Override
    @JsonIgnore
    @Nullable
    public String getHeight() {
        int height = this.getOriginalDimension().height;
        if (height > 0) {
            return String.valueOf(height);
        }
        return null;
    }

    @Override
    @JsonIgnore
    @Nullable
    public String getWidth() {
        int width = this.getOriginalDimension().width;
        if (width > 0) {
            return String.valueOf(width);
        }
        return null;
    }

    @Override
    @JsonIgnore
    public String getSrcUriTemplate() {
        if (this.ngdmImage) {
            return this.prepareNgdmSrcUriTemplate();
        }
        return super.getSrcUriTemplate();
    }

    @Override
    @JsonIgnore
    @Deprecated
    public int getLazyThreshold() {
        return 0;
    }

    @Override
    @JsonIgnore
    public int @NotNull [] getWidths() {
        return super.getWidths();
    }

    @Override
    @JsonIgnore
    public boolean isDmImage() {
        return super.isDmImage();
    }

    @Override
    @JsonIgnore
    @Deprecated
    public List<ImageArea> getAreas() {
        return super.getAreas();
    }

    @Override
    protected void initResource() {
        this.resource = Utils.getWrappedImageResourceWithInheritance(this.resource, this.linkManager, this.currentStyle, this.currentPage);
    }

    @Override
    public boolean isLazyEnabled() {
        return !this.disableLazyLoading;
    }

    private Dimension getOriginalDimension() {
        if (this.dimension == null) {
            this.dimension = this.getOriginalDimensionInternal();
        }
        return this.dimension;
    }

    private Dimension getOriginalDimensionInternal() {
        Resource assetResource;
        ValueMap inheritedResourceProperties = this.resource.getValueMap();
        String inheritedFileReference = (String)inheritedResourceProperties.get("fileReference", String.class);
        String resizeWidth = (String)this.currentStyle.get("resizeWidth", String.class);
        if (StringUtils.isNotEmpty((CharSequence)inheritedFileReference) && (assetResource = this.request.getResourceResolver().getResource(inheritedFileReference)) != null) {
            Dimension dimension;
            Asset asset = (Asset)assetResource.adaptTo(Asset.class);
            EnhancedRendition original = null;
            if (asset != null) {
                original = new EnhancedRendition(asset.getOriginal());
            }
            if (original != null && (dimension = original.getDimension()) != null) {
                if (resizeWidth != null && Integer.parseInt(resizeWidth) > 0 && (double)Integer.parseInt(resizeWidth) < dimension.getWidth()) {
                    int calculatedHeight = (int)Math.round((double)Integer.parseInt(resizeWidth) * (dimension.getHeight() / (double)((float)dimension.getWidth())));
                    return new Dimension(Integer.parseInt(resizeWidth), calculatedHeight);
                }
                return dimension;
            }
        }
        return new Dimension(0, 0);
    }

    private boolean isNgdmSupportAvailable() {
        return this.nextGenDynamicMediaConfig != null && this.nextGenDynamicMediaConfig.enabled() && StringUtils.isNotBlank((CharSequence)this.nextGenDynamicMediaConfig.getRepositoryId());
    }

    private void initNextGenerationDynamicMedia() {
        this.initResource();
        this.properties = this.resource.getValueMap();
        String fileReference = (String)this.properties.get("fileReference", String.class);
        String smartCrop = (String)this.properties.get("smartCrop", String.class);
        if (ImageImpl.isNgdmImageReference(fileReference)) {
            int width = (Integer)this.currentStyle.get("resizeWidth", (Object)640);
            NextGenDMImageURIBuilder builder = new NextGenDMImageURIBuilder(this.nextGenDynamicMediaConfig, fileReference).withPreferWebp(true).withWidth(width);
            if (StringUtils.isNotEmpty((CharSequence)smartCrop)) {
                builder.withSmartCrop(smartCrop);
            }
            this.src = builder.build();
            this.ngdmImage = true;
            this.hasContent = true;
        }
    }

    @NotNull
    private String prepareNgdmSrcUriTemplate() {
        this.srcUriTemplate = this.src.replaceFirst("width=\\d+", "width=%7B.width%7D");
        String ret = this.src.replaceFirst("width=\\d+", "width={.width}");
        return ret;
    }

    public static boolean isNgdmImageReference(String fileReference) {
        return StringUtils.isNotBlank((CharSequence)fileReference) && fileReference.startsWith("/urn:");
    }
}

