/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1.datalayer.builder;

import com.adobe.cq.wcm.core.components.models.datalayer.AssetData;
import com.adobe.cq.wcm.core.components.models.datalayer.ComponentData;
import com.adobe.cq.wcm.core.components.models.datalayer.ContainerData;
import com.adobe.cq.wcm.core.components.models.datalayer.ContentFragmentData;
import com.adobe.cq.wcm.core.components.models.datalayer.ImageData;
import com.adobe.cq.wcm.core.components.models.datalayer.PageData;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.DataLayerSupplier;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataLayerSupplierImpl
implements DataLayerSupplier {
    @NotNull
    private final DataLayerSupplier wrappedSupplier;
    private @Nullable Supplier<@NotNull String> idSupplier;
    @Nullable
    private Supplier<String> typeSupplier;
    @Nullable
    private Supplier<Date> lastModifiedDateSupplier;
    @Nullable
    private Supplier<String> parentIdSupplier;
    @Nullable
    private Supplier<String> titleSupplier;
    @Nullable
    private Supplier<String> descriptionSupplier;
    @Nullable
    private Supplier<String> textSupplier;
    @Nullable
    private Supplier<String> linkUrlSupplier;
    @Nullable
    private Supplier<String[]> shownItemsSupplier;
    @Nullable
    private Supplier<AssetData> assetDataSupplier;
    @Nullable
    private Supplier<String> urlSupplier;
    @Nullable
    private Supplier<String> formatSupplier;
    @Nullable
    private Supplier<String[]> tagsSupplier;
    @Nullable
    private Supplier<Map<String, Object>> smartTagsSupplier;
    @Nullable
    private Supplier<String> templatePathSupplier;
    @Nullable
    private Supplier<String> languageSupplier;
    @Nullable
    private Supplier<ContentFragmentData.ElementData[]> contentFragmentElementsSupplier;
    @Nullable
    private Supplier<Map<String, Object>> embeddableSupplier;

    public DataLayerSupplierImpl(@NotNull DataLayerSupplier dataLayerSupplier) {
        this.wrappedSupplier = dataLayerSupplier;
    }

    public static DataLayerSupplier extend(@NotNull ComponentData data) {
        DataLayerSupplierImpl supplier = new DataLayerSupplierImpl(DataLayerSupplier.EMPTY_SUPPLIER).setId(data::getId).setType(data::getType).setLastModifiedDate(data::getLastModifiedDate).setParentId(data::getParentId).setTitle(data::getTitle).setDescription(data::getDescription).setText(data::getText).setLinkUrl(data::getLinkUrl);
        if (data instanceof PageData) {
            PageData pageData = (PageData)data;
            supplier.setUrl(pageData::getUrl).setTags(pageData::getTags).setTemplatePath(pageData::getTemplatePath).setLanguage(pageData::getLanguage);
        }
        if (data instanceof ContainerData) {
            supplier.setShownItems(((ContainerData)data)::getShownItems);
        }
        if (data instanceof ImageData) {
            supplier.setAssetData(((ImageData)data)::getAssetData);
        }
        return supplier;
    }

    public static DataLayerSupplier extend(@NotNull AssetData data) {
        return new DataLayerSupplierImpl(DataLayerSupplier.EMPTY_SUPPLIER).setId(data::getId).setUrl(data::getUrl).setFormat(data::getFormat).setTags(data::getTags).setLastModifiedDate(data::getLastModifiedDate);
    }

    @Override
    @NotNull
    public @NotNull Supplier<@NotNull String> getId() {
        return Optional.ofNullable(this.idSupplier).orElseGet(this.wrappedSupplier::getId);
    }

    public DataLayerSupplierImpl setId(@NotNull @NotNull Supplier<@NotNull String> supplier) {
        this.idSupplier = supplier;
        return this;
    }

    @Override
    @NotNull
    public Optional<Supplier<String>> getType() {
        if (this.typeSupplier != null) {
            return Optional.of(this.typeSupplier);
        }
        return this.wrappedSupplier.getType();
    }

    public DataLayerSupplierImpl setType(@NotNull Supplier<String> supplier) {
        this.typeSupplier = supplier;
        return this;
    }

    @Override
    @NotNull
    public Optional<Supplier<Date>> getLastModifiedDate() {
        if (this.lastModifiedDateSupplier != null) {
            return Optional.of(this.lastModifiedDateSupplier);
        }
        return this.wrappedSupplier.getLastModifiedDate();
    }

    public DataLayerSupplierImpl setLastModifiedDate(@NotNull Supplier<Date> supplier) {
        this.lastModifiedDateSupplier = supplier;
        return this;
    }

    @Override
    @NotNull
    public Optional<Supplier<String>> getParentId() {
        if (this.parentIdSupplier != null) {
            return Optional.of(this.parentIdSupplier);
        }
        return this.wrappedSupplier.getParentId();
    }

    public DataLayerSupplierImpl setParentId(@NotNull Supplier<String> supplier) {
        this.parentIdSupplier = supplier;
        return this;
    }

    @Override
    @NotNull
    public Optional<Supplier<String>> getTitle() {
        if (this.titleSupplier != null) {
            return Optional.of(this.titleSupplier);
        }
        return this.wrappedSupplier.getTitle();
    }

    public DataLayerSupplierImpl setTitle(@NotNull Supplier<String> supplier) {
        this.titleSupplier = supplier;
        return this;
    }

    @Override
    @NotNull
    public Optional<Supplier<String>> getDescription() {
        if (this.descriptionSupplier != null) {
            return Optional.of(this.descriptionSupplier);
        }
        return this.wrappedSupplier.getDescription();
    }

    public DataLayerSupplierImpl setDescription(@NotNull Supplier<String> supplier) {
        this.descriptionSupplier = supplier;
        return this;
    }

    @Override
    @NotNull
    public Optional<Supplier<String>> getText() {
        if (this.textSupplier != null) {
            return Optional.of(this.textSupplier);
        }
        return this.wrappedSupplier.getText();
    }

    public DataLayerSupplierImpl setText(@NotNull Supplier<String> supplier) {
        this.textSupplier = supplier;
        return this;
    }

    @Override
    @NotNull
    public Optional<Supplier<String>> getLinkUrl() {
        if (this.linkUrlSupplier != null) {
            return Optional.of(this.linkUrlSupplier);
        }
        return this.wrappedSupplier.getLinkUrl();
    }

    public DataLayerSupplierImpl setLinkUrl(@NotNull Supplier<String> supplier) {
        this.linkUrlSupplier = supplier;
        return this;
    }

    @Override
    @NotNull
    public Optional<Supplier<String[]>> getShownItems() {
        if (this.shownItemsSupplier != null) {
            return Optional.of(this.shownItemsSupplier);
        }
        return this.wrappedSupplier.getShownItems();
    }

    public DataLayerSupplierImpl setShownItems(@NotNull Supplier<String[]> supplier) {
        this.shownItemsSupplier = supplier;
        return this;
    }

    @Override
    @NotNull
    public Optional<Supplier<AssetData>> getAssetData() {
        if (this.assetDataSupplier != null) {
            return Optional.of(this.assetDataSupplier);
        }
        return this.wrappedSupplier.getAssetData();
    }

    public DataLayerSupplierImpl setAssetData(@NotNull Supplier<AssetData> supplier) {
        this.assetDataSupplier = supplier;
        return this;
    }

    @Override
    @NotNull
    public Optional<Supplier<String>> getUrl() {
        if (this.urlSupplier != null) {
            return Optional.of(this.urlSupplier);
        }
        return this.wrappedSupplier.getUrl();
    }

    public DataLayerSupplierImpl setUrl(@NotNull Supplier<String> supplier) {
        this.urlSupplier = supplier;
        return this;
    }

    @Override
    @NotNull
    public Optional<Supplier<String>> getFormat() {
        if (this.formatSupplier != null) {
            return Optional.of(this.formatSupplier);
        }
        return this.wrappedSupplier.getFormat();
    }

    public DataLayerSupplierImpl setFormat(@NotNull Supplier<String> supplier) {
        this.formatSupplier = supplier;
        return this;
    }

    @Override
    @NotNull
    public Optional<Supplier<String[]>> getTags() {
        if (this.tagsSupplier != null) {
            return Optional.of(this.tagsSupplier);
        }
        return this.wrappedSupplier.getTags();
    }

    public DataLayerSupplierImpl setTags(@NotNull Supplier<String[]> supplier) {
        this.tagsSupplier = supplier;
        return this;
    }

    @Override
    @NotNull
    public Optional<Supplier<Map<String, Object>>> getSmartTags() {
        if (this.smartTagsSupplier != null) {
            return Optional.of(this.smartTagsSupplier);
        }
        return this.wrappedSupplier.getSmartTags();
    }

    public DataLayerSupplierImpl setSmartTags(@NotNull Supplier<Map<String, Object>> supplier) {
        this.smartTagsSupplier = supplier;
        return this;
    }

    @Override
    @NotNull
    public Optional<Supplier<Map<String, Object>>> getEmbeddableDetails() {
        if (this.embeddableSupplier != null) {
            return Optional.of(this.embeddableSupplier);
        }
        return this.wrappedSupplier.getEmbeddableDetails();
    }

    public DataLayerSupplierImpl setEmbeddableDetails(@NotNull Supplier<Map<String, Object>> supplier) {
        this.embeddableSupplier = supplier;
        return this;
    }

    @Override
    @NotNull
    public Optional<Supplier<String>> getTemplatePath() {
        if (this.templatePathSupplier != null) {
            return Optional.of(this.templatePathSupplier);
        }
        return this.wrappedSupplier.getTemplatePath();
    }

    public DataLayerSupplierImpl setTemplatePath(@NotNull Supplier<String> supplier) {
        this.templatePathSupplier = supplier;
        return this;
    }

    @Override
    @NotNull
    public Optional<Supplier<String>> getLanguage() {
        if (this.languageSupplier != null) {
            return Optional.of(this.languageSupplier);
        }
        return this.wrappedSupplier.getLanguage();
    }

    public DataLayerSupplierImpl setLanguage(@NotNull Supplier<String> supplier) {
        this.languageSupplier = supplier;
        return this;
    }

    @Override
    @NotNull
    public Optional<Supplier<ContentFragmentData.ElementData[]>> getContentFragmentElements() {
        if (this.contentFragmentElementsSupplier != null) {
            return Optional.of(this.contentFragmentElementsSupplier);
        }
        return this.wrappedSupplier.getContentFragmentElements();
    }

    public DataLayerSupplierImpl setContentFragmentElements(@NotNull Supplier<ContentFragmentData.ElementData[]> supplier) {
        this.contentFragmentElementsSupplier = supplier;
        return this;
    }
}

