/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1.contentfragment;

import com.adobe.cq.dam.cfm.content.FragmentRenderService;
import com.adobe.cq.dam.cfm.converter.ContentTypeConverter;
import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.export.json.ContainerExporter;
import com.adobe.cq.wcm.core.components.internal.ContentFragmentUtils;
import com.adobe.cq.wcm.core.components.internal.models.v1.contentfragment.DAMContentFragmentImpl;
import com.adobe.cq.wcm.core.components.internal.models.v1.datalayer.ContentFragmentDataImpl;
import com.adobe.cq.wcm.core.components.models.contentfragment.ContentFragment;
import com.adobe.cq.wcm.core.components.models.contentfragment.DAMContentFragment;
import com.adobe.cq.wcm.core.components.models.datalayer.ComponentData;
import com.adobe.cq.wcm.core.components.models.datalayer.ContentFragmentData;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.ContentFragmentDataBuilder;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.DataLayerBuilder;
import com.adobe.cq.wcm.core.components.util.AbstractComponentImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.apache.sling.models.factory.ModelFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={ContentFragment.class, DAMContentFragment.class, ContainerExporter.class, ComponentExporter.class}, resourceType={"core/wcm/components/contentfragment/v1/contentfragment"})
@Exporter(name="jackson", extensions={"json"})
public class ContentFragmentImpl
extends AbstractComponentImpl
implements ContentFragment {
    public static final String RESOURCE_TYPE = "core/wcm/components/contentfragment/v1/contentfragment";
    @Self(injectionStrategy=InjectionStrategy.REQUIRED)
    private SlingHttpServletRequest slingHttpServletRequest;
    @Inject
    private FragmentRenderService renderService;
    @Inject
    private ContentTypeConverter contentTypeConverter;
    @Inject
    private ModelFactory modelFactory;
    @SlingObject
    private ResourceResolver resourceResolver;
    @ScriptVariable
    private Resource resource;
    @ValueMapValue(name="fragmentPath", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String fragmentPath;
    @ValueMapValue(name="elementNames", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String[] elementNames;
    @ValueMapValue(name="variationName", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String variationName;
    @ValueMapValue(name="displayMode", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String displayMode;
    private DAMContentFragment damContentFragment = new EmptyContentFragment();

    @PostConstruct
    private void initModel() {
        Resource fragmentResource;
        if (StringUtils.isNotEmpty((CharSequence)this.fragmentPath) && (fragmentResource = this.resourceResolver.getResource(this.fragmentPath)) != null) {
            this.damContentFragment = new DAMContentFragmentImpl(fragmentResource, this.contentTypeConverter, this.variationName, this.elementNames);
        }
    }

    @Override
    @Nullable
    public String getTitle() {
        return this.damContentFragment.getTitle();
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.damContentFragment.getDescription();
    }

    @Override
    @Nullable
    public String getType() {
        return this.damContentFragment.getType();
    }

    @Override
    @NotNull
    public String getName() {
        return this.damContentFragment.getName();
    }

    @Override
    @NotNull
    public String getGridResourceType() {
        return ContentFragmentUtils.getGridResourceType(this.resource);
    }

    @Override
    @NotNull
    public String getEditorJSON() {
        return this.damContentFragment.getEditorJSON();
    }

    @Override
    @NotNull
    public Map<String, DAMContentFragment.DAMContentElement> getExportedElements() {
        return this.damContentFragment.getExportedElements();
    }

    @Override
    @NotNull
    public String[] getExportedElementsOrder() {
        return this.damContentFragment.getExportedElementsOrder();
    }

    @Override
    @Nullable
    public List<DAMContentFragment.DAMContentElement> getElements() {
        return this.damContentFragment.getElements();
    }

    @Override
    @Nullable
    public List<Resource> getAssociatedContent() {
        return this.damContentFragment.getAssociatedContent();
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.slingHttpServletRequest.getResource().getResourceType();
    }

    @Override
    @NotNull
    public Map<String, ? extends ComponentExporter> getExportedItems() {
        return ContentFragmentUtils.getComponentExporters(this.resource.listChildren(), this.modelFactory, this.slingHttpServletRequest, this.resource);
    }

    @Override
    @NotNull
    public String[] getExportedItemsOrder() {
        return ContentFragmentUtils.getItemsOrder(this.getExportedItems());
    }

    @Override
    @Nullable
    public String[] getParagraphs() {
        if (!"singleText".equals(this.displayMode)) {
            return null;
        }
        if (this.damContentFragment.getElements() == null || this.damContentFragment.getElements().isEmpty()) {
            return null;
        }
        DAMContentFragment.DAMContentElement damContentElement = this.damContentFragment.getElements().get(0);
        if (!damContentElement.isMultiLine()) {
            return null;
        }
        String content = this.renderService.render(this.resource);
        if (content == null) {
            return null;
        }
        return content.split("(?=(<p>|<h1>|<h2>|<h3>|<h4>|<h5>|<h6>))");
    }

    @Override
    @NotNull
    protected ComponentData getComponentData() {
        return ((ContentFragmentDataBuilder)DataLayerBuilder.extending(super.getComponentData()).asContentFragment().withTitle(this::getTitle)).withElementsData(() -> {
            ArrayList elementsData = new ArrayList();
            Optional.ofNullable(this.getElements()).map(elements -> {
                for (DAMContentFragment.DAMContentElement contentElement : elements) {
                    elementsData.add(new ContentFragmentDataImpl.ElementDataImpl(contentElement));
                }
                return Optional.empty();
            });
            return elementsData.toArray(new ContentFragmentData.ElementData[0]);
        }).build();
    }

    private static class EmptyContentFragment
    implements DAMContentFragment {
        private EmptyContentFragment() {
        }

        @Override
        @Nullable
        public String getTitle() {
            return null;
        }

        @Override
        @Nullable
        public String getDescription() {
            return null;
        }

        @Override
        @Nullable
        public String getType() {
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            return "";
        }

        @Override
        @Nullable
        public List<DAMContentFragment.DAMContentElement> getElements() {
            return null;
        }

        @Override
        @NotNull
        public Map<String, DAMContentFragment.DAMContentElement> getExportedElements() {
            return new HashMap<String, DAMContentFragment.DAMContentElement>();
        }

        @Override
        @NotNull
        public String[] getExportedElementsOrder() {
            return new String[0];
        }

        @Override
        @Nullable
        public List<Resource> getAssociatedContent() {
            return null;
        }
    }
}

