/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.internal.LocalizationUtils;
import com.adobe.cq.wcm.core.components.models.Search;
import com.adobe.cq.wcm.core.components.util.AbstractComponentImpl;
import com.day.cq.wcm.api.LanguageManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.designer.Style;
import com.day.cq.wcm.msm.api.LiveRelationshipManager;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.jetbrains.annotations.NotNull;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Search.class, ComponentExporter.class}, resourceType={"core/wcm/components/search/v1/search"})
@Exporter(name="jackson", extensions={"json"})
public class SearchImpl
extends AbstractComponentImpl
implements Search {
    protected static final String RESOURCE_TYPE = "core/wcm/components/search/v1/search";
    public static final int PROP_RESULTS_SIZE_DEFAULT = 10;
    public static final int PROP_SEARCH_TERM_MINIMUM_LENGTH_DEFAULT = 3;
    @Self
    private SlingHttpServletRequest request;
    @ScriptVariable
    private Page currentPage;
    @ScriptVariable
    private Style currentStyle;
    @OSGiService
    private LanguageManager languageManager;
    @OSGiService
    private LiveRelationshipManager relationshipManager;
    private String relativePath;
    private int resultsSize;
    private int searchTermMinimumLength;
    private String searchRootPagePath;

    @PostConstruct
    private void initModel() {
        this.resultsSize = (Integer)this.currentStyle.get("resultsSize", (Object)10);
        this.searchTermMinimumLength = (Integer)this.currentStyle.get("searchTermMinimumLength", (Object)3);
        Resource currentResource = this.request.getResource();
        this.relativePath = Optional.ofNullable(this.currentPage.getPageManager().getContainingPage(currentResource)).map(Page::getPath).map(path -> StringUtils.substringAfter((String)currentResource.getPath(), (String)path)).orElse(null);
    }

    @Override
    public int getResultsSize() {
        return this.resultsSize;
    }

    @Override
    public int getSearchTermMinimumLength() {
        return this.searchTermMinimumLength;
    }

    @Override
    @NotNull
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    @NotNull
    public String getSearchRootPagePath() {
        if (this.searchRootPagePath == null) {
            this.searchRootPagePath = Optional.ofNullable(this.request.getResource().getValueMap().get("searchRoot", String.class)).flatMap(searchRoot -> LocalizationUtils.getLocalPage(searchRoot, this.currentPage, this.request.getResourceResolver(), this.languageManager, this.relationshipManager)).map(Page::getPath).orElseGet(() -> ((Page)this.currentPage).getPath());
        }
        return this.searchRootPagePath;
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.request.getResource().getResourceType();
    }
}

