/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.export.json.ContainerExporter;
import com.adobe.cq.export.json.SlingModelFilter;
import com.adobe.cq.wcm.core.components.commons.link.LinkManager;
import com.adobe.cq.wcm.core.components.internal.Utils;
import com.adobe.cq.wcm.core.components.models.Page;
import com.adobe.cq.wcm.core.components.models.datalayer.PageData;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.DataLayerBuilder;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.PageDataBuilder;
import com.adobe.cq.wcm.core.components.util.AbstractComponentImpl;
import com.day.cq.tagging.Tag;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.designer.Design;
import com.day.cq.wcm.api.designer.Style;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.factory.ModelFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Page.class, ContainerExporter.class}, resourceType={"core/wcm/components/page/v1/page"})
@Exporter(name="jackson", extensions={"json"})
public class PageImpl
extends AbstractComponentImpl
implements Page {
    protected static final String RESOURCE_TYPE = "core/wcm/components/page/v1/page";
    @ScriptVariable
    protected com.day.cq.wcm.api.Page currentPage;
    @ScriptVariable
    protected ValueMap pageProperties;
    @ScriptVariable
    @JsonIgnore
    protected Design currentDesign;
    @ScriptVariable(injectionStrategy=InjectionStrategy.OPTIONAL)
    @JsonIgnore
    @Nullable
    protected Style currentStyle;
    @ScriptVariable
    @JsonIgnore
    protected ResourceResolver resolver;
    @Inject
    private ModelFactory modelFactory;
    @Inject
    private SlingModelFilter slingModelFilter;
    @Self
    protected LinkManager linkManager;
    protected String[] keywords = new String[0];
    protected String designPath;
    protected String staticDesignPath;
    protected String title;
    protected String description;
    protected String brandSlug;
    protected String[] clientLibCategories = new String[0];
    protected Calendar lastModifiedDate;
    protected String templateName;
    protected static final String DEFAULT_TEMPLATE_EDITOR_CLIENTLIB = "wcm.foundation.components.parsys.allowedcomponents";
    protected static final String PN_CLIENTLIBS = "clientlibs";
    protected static final String PN_BRANDSLUG = "brandSlug";
    private Map<String, ComponentExporter> childModels = null;
    private String resourceType;
    private Set<String> resourceTypes;
    @JsonIgnore
    protected Map<String, String> favicons = new HashMap<String, String>();

    @PostConstruct
    protected void initModel() {
        String designPath;
        this.title = this.currentPage.getTitle();
        this.description = this.currentPage.getDescription();
        if (StringUtils.isBlank((CharSequence)this.title)) {
            this.title = this.currentPage.getName();
        }
        Tag[] tags = this.currentPage.getTags();
        this.keywords = new String[tags.length];
        int index = 0;
        for (Tag tag : tags) {
            this.keywords[index++] = tag.getTitle(this.currentPage.getLanguage(false));
        }
        if (this.currentDesign != null && !"/etc/designs/default".equals(designPath = this.currentDesign.getPath())) {
            this.designPath = designPath;
            if (this.resolver.getResource(designPath + "/static.css") != null) {
                this.staticDesignPath = designPath + "/static.css";
            }
            this.loadFavicons(designPath);
        }
        this.populateClientlibCategories();
        this.templateName = this.extractTemplateName();
        this.brandSlug = Utils.getInheritedValue(this.currentPage, PN_BRANDSLUG);
    }

    protected String extractTemplateName() {
        int i;
        String templateName = null;
        String templatePath = (String)this.pageProperties.get("cq:template", String.class);
        if (StringUtils.isNotEmpty((CharSequence)templatePath) && (i = templatePath.lastIndexOf(47)) > 0) {
            templateName = templatePath.substring(i + 1);
        }
        return templateName;
    }

    @Override
    public String getLanguage() {
        return this.currentPage == null ? Locale.getDefault().toLanguageTag() : this.currentPage.getLanguage(false).toLanguageTag();
    }

    @Override
    public Calendar getLastModifiedDate() {
        if (this.lastModifiedDate == null) {
            this.lastModifiedDate = (Calendar)this.pageProperties.get("cq:lastModified", Calendar.class);
        }
        return this.lastModifiedDate;
    }

    @Override
    @JsonIgnore
    public String[] getKeywords() {
        return Arrays.copyOf(this.keywords, this.keywords.length);
    }

    @Override
    public String getDesignPath() {
        return this.designPath;
    }

    @Override
    public String getStaticDesignPath() {
        return this.staticDesignPath;
    }

    @Override
    @JsonIgnore
    @Deprecated
    public Map<String, String> getFavicons() {
        return this.favicons;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getBrandSlug() {
        return this.brandSlug;
    }

    @Override
    public String getTemplateName() {
        return this.templateName;
    }

    @Override
    @JsonIgnore
    public String[] getClientLibCategories() {
        return Arrays.copyOf(this.clientLibCategories, this.clientLibCategories.length);
    }

    @Override
    @JsonIgnore
    public Set<String> getComponentsResourceTypes() {
        if (this.resourceTypes == null) {
            this.resourceTypes = Utils.getPageResourceTypes(this.currentPage, this.request, this.modelFactory);
        }
        return this.resourceTypes;
    }

    @Override
    @NotNull
    public Map<String, ? extends ComponentExporter> getExportedItems() {
        if (this.childModels == null) {
            this.childModels = this.getChildModels(this.request, ComponentExporter.class);
        }
        return this.childModels;
    }

    @Override
    @NotNull
    public String[] getExportedItemsOrder() {
        Map<String, ? extends ComponentExporter> models = this.getExportedItems();
        if (models.isEmpty()) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return models.keySet().toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    @Override
    @NotNull
    public String getExportedType() {
        if (StringUtils.isEmpty((CharSequence)this.resourceType)) {
            this.resourceType = (String)this.pageProperties.get("sling:resourceType", String.class);
            if (StringUtils.isEmpty((CharSequence)this.resourceType)) {
                this.resourceType = this.currentPage.getContentResource().getResourceType();
            }
        }
        return this.resourceType;
    }

    @NotNull
    private <T> Map<String, T> getChildModels(@NotNull SlingHttpServletRequest slingRequest, @NotNull Class<T> modelClass) {
        LinkedHashMap<String, Object> itemWrappers = new LinkedHashMap<String, Object>();
        for (Resource child : this.slingModelFilter.filterChildResources(this.request.getResource().getChildren())) {
            itemWrappers.put(child.getName(), this.modelFactory.getModelFromWrappedRequest(slingRequest, child, modelClass));
        }
        return itemWrappers;
    }

    protected void loadFavicons(String designPath) {
        this.favicons.put("faviconIco", this.getFaviconPath(designPath, "favicon.ico"));
        this.favicons.put("faviconPng", this.getFaviconPath(designPath, "favicon_32.png"));
        this.favicons.put("touchIcon120", this.getFaviconPath(designPath, "touch-icon_120.png"));
        this.favicons.put("touchIcon152", this.getFaviconPath(designPath, "touch-icon_152.png"));
        this.favicons.put("touchIcon60", this.getFaviconPath(designPath, "touch-icon_60.png"));
        this.favicons.put("touchIcon76", this.getFaviconPath(designPath, "touch-icon_76.png"));
    }

    protected String getFaviconPath(String designPath, String faviconName) {
        String path = designPath + "/" + faviconName;
        if (this.resolver.getResource(path) == null) {
            return null;
        }
        return path;
    }

    protected void populateClientlibCategories() {
        Resource templateResource;
        ArrayList<String> categories = new ArrayList<String>();
        Template template = this.currentPage.getTemplate();
        if (template != null && template.hasStructureSupport() && (templateResource = (Resource)template.adaptTo(Resource.class)) != null) {
            this.addDefaultTemplateEditorClientLib(templateResource, categories);
            this.addPolicyClientLibs(categories);
        }
        this.clientLibCategories = categories.toArray(new String[0]);
    }

    protected void addDefaultTemplateEditorClientLib(Resource templateResource, List<String> categories) {
        if (this.currentPage.getPath().startsWith(templateResource.getPath())) {
            categories.add(DEFAULT_TEMPLATE_EDITOR_CLIENTLIB);
        }
    }

    protected void addPolicyClientLibs(List<String> categories) {
        if (this.currentStyle != null) {
            Collections.addAll(categories, (Object[])this.currentStyle.get(PN_CLIENTLIBS, (Object)ArrayUtils.EMPTY_STRING_ARRAY));
        }
    }

    @Override
    @NotNull
    protected final PageData getComponentData() {
        return ((PageDataBuilder)((PageDataBuilder)((PageDataBuilder)DataLayerBuilder.extending(super.getComponentData()).asPage().withTitle(this::getTitle)).withLastModifiedDate(() -> Optional.ofNullable(this.getLastModifiedDate()).map(Calendar::getTime).orElseGet(() -> Optional.ofNullable(this.pageProperties.get("jcr:created", Calendar.class)).map(Calendar::getTime).orElse(null)))).withTags(() -> Arrays.copyOf(this.keywords, this.keywords.length)).withDescription(() -> (String)this.pageProperties.get("jcr:description", String.class))).withTemplatePath(() -> Optional.ofNullable(this.currentPage.getTemplate()).map(Template::getPath).orElse(null)).withUrl(() -> this.linkManager.get(this.currentPage).build().getURL()).withLanguage(this::getLanguage).build();
    }
}

