/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.wcm.core.components.commons.link.Link;
import com.adobe.cq.wcm.core.components.models.ImageArea;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ImageAreaImpl
implements ImageArea {
    private final String shape;
    private final String coordinates;
    private final String relativeCoordinates;
    protected Link link;
    private final String alt;

    public ImageAreaImpl(String shape, String coordinates, String relativeCoordinates, @NotNull Link link, String alt) {
        this.shape = shape;
        this.coordinates = coordinates;
        this.relativeCoordinates = relativeCoordinates;
        this.link = link;
        this.alt = alt;
    }

    @Override
    public String getShape() {
        return this.shape;
    }

    @Override
    public String getCoordinates() {
        return this.coordinates;
    }

    @Override
    public String getRelativeCoordinates() {
        return this.relativeCoordinates;
    }

    @Override
    public String getHref() {
        return StringUtils.defaultString((String)this.link.getURL());
    }

    @Override
    public String getTarget() {
        String target = null;
        Map<String, String> attrs = this.link.getHtmlAttributes();
        if (attrs != null) {
            target = attrs.get("target");
        }
        return StringUtils.defaultString(target);
    }

    @Override
    public String getAlt() {
        return this.alt;
    }
}

