/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.export.json.SlingModelFilter;
import com.adobe.cq.wcm.core.components.commons.link.Link;
import com.adobe.cq.wcm.core.components.commons.link.LinkManager;
import com.adobe.cq.wcm.core.components.internal.Utils;
import com.adobe.cq.wcm.core.components.models.Container;
import com.adobe.cq.wcm.core.components.models.ListItem;
import com.adobe.cq.wcm.core.components.models.datalayer.ContainerData;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.DataLayerBuilder;
import com.adobe.cq.wcm.core.components.util.AbstractComponentImpl;
import com.day.cq.wcm.api.designer.Style;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.factory.ModelFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractContainerImpl
extends AbstractComponentImpl
implements Container {
    @Self
    protected LinkManager linkManager;
    @ScriptVariable(injectionStrategy=InjectionStrategy.OPTIONAL)
    @JsonIgnore
    @Nullable
    protected Style currentStyle;
    @OSGiService
    protected SlingModelFilter slingModelFilter;
    @OSGiService
    protected ModelFactory modelFactory;
    private List<ListItem> items;
    private String[] exportedItemsOrder;
    private String backgroundStyle;

    @Deprecated
    @NotNull
    protected abstract List<? extends ListItem> readItems();

    private Optional<String> getBackgroundColor() {
        return Optional.ofNullable(this.currentStyle).filter(style -> (Boolean)style.get("backgroundColorEnabled", (Object)Boolean.FALSE)).flatMap(style -> Optional.ofNullable(this.resource.getValueMap().get("backgroundColor", String.class))).filter(StringUtils::isNotEmpty);
    }

    private Optional<String> getBackgroundImage() {
        return Optional.ofNullable(this.currentStyle).filter(style -> (Boolean)style.get("backgroundImageEnabled", (Object)Boolean.FALSE)).flatMap(style -> Utils.getOptionalLink(this.linkManager.get(this.resource).withLinkUrlPropertyName("backgroundImageReference").build()).map(Link::getURL)).filter(StringUtils::isNotEmpty);
    }

    @Override
    @JsonIgnore
    @Deprecated
    @NotNull
    public List<ListItem> getItems() {
        if (this.items == null) {
            this.items = this.readItems().stream().map(i -> i).collect(Collectors.toList());
        }
        return this.items;
    }

    @Override
    @Nullable
    public final String getBackgroundStyle() {
        if (this.backgroundStyle == null) {
            StringBuilder styleBuilder = new StringBuilder();
            this.getBackgroundImage().ifPresent(image -> styleBuilder.append("background-image:url(").append((String)image).append(");background-size:cover;background-repeat:no-repeat;"));
            this.getBackgroundColor().ifPresent(color -> styleBuilder.append("background-color:").append((String)color).append(";"));
            this.backgroundStyle = styleBuilder.toString();
        }
        if (StringUtils.isEmpty((CharSequence)this.backgroundStyle)) {
            return null;
        }
        return this.backgroundStyle;
    }

    @Override
    @NotNull
    public final String getExportedType() {
        return this.resource.getResourceType();
    }

    @NotNull
    public abstract LinkedHashMap<String, ? extends ComponentExporter> getExportedItems();

    @Override
    @NotNull
    public final String[] getExportedItemsOrder() {
        if (this.exportedItemsOrder == null) {
            this.exportedItemsOrder = ((LinkedHashMap)this.getExportedItems()).keySet().toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        }
        return Arrays.copyOf(this.exportedItemsOrder, this.exportedItemsOrder.length);
    }

    @Override
    @NotNull
    protected ContainerData getComponentData() {
        return DataLayerBuilder.extending(super.getComponentData()).asContainer().withShownItems(this::getDataLayerShownItems).build();
    }

    @JsonIgnore
    public abstract String[] getDataLayerShownItems();
}

