/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.helper.image;

import com.adobe.cq.wcm.spi.AssetDelivery;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetDeliveryHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(AssetDeliveryHelper.class);
    private static String COMMA = ",";
    private static String PERCENTAGE = "p";
    private static String WIDTH_PARAMETER = "width";
    private static String QUALITY_PARAMETER = "quality";
    private static String CROP_PARAMETER = "c";
    private static String ROTATE_PARAMETER = "r";
    private static String FLIP_PARAMETER = "flip";
    private static String FORMAT_PARAMETER = "format";
    private static String PATH_PARAMETER = "path";
    private static String SEO_PARAMETER = "seoname";
    private static String PREFER_WEBP_PARAMETER = "preferwebp";
    private static String HORIZONTAL_FLIP = "HORIZONTAL";
    private static String VERTICAL_FLIP = "VERTICAL";
    private static String HORIZONTAL_AND_VERTICAL_FLIP = "HORIZONTAL_AND_VERTICAL";
    private static int PSEUDO_WIDTH_PARAM = Integer.MAX_VALUE;

    public static String getSrcSet(@NotNull AssetDelivery assetDelivery, @NotNull Resource imageComponentResource, @NotNull String imageName, @NotNull String extension, int[] smartSizes, int jpegQuality) {
        if (smartSizes.length == 0) {
            return null;
        }
        ArrayList<String> srcsetList = new ArrayList<String>();
        for (int i = 0; i < smartSizes.length; ++i) {
            String src = AssetDeliveryHelper.getSrc(assetDelivery, imageComponentResource, imageName, extension, smartSizes[i], jpegQuality);
            if (StringUtils.isEmpty((CharSequence)src)) continue;
            srcsetList.add(src + " " + smartSizes[i] + "w");
        }
        if (srcsetList.size() > 0) {
            return StringUtils.join(srcsetList, (String)COMMA);
        }
        return null;
    }

    public static String getSrcUriTemplate(@NotNull AssetDelivery assetDelivery, @NotNull Resource imageComponentResource, @NotNull String imageName, @NotNull String extension, @Nullable Integer jpegQuality, @NotNull String widthPlaceholder) {
        String templateUrl = AssetDeliveryHelper.getSrc(assetDelivery, imageComponentResource, imageName, extension, PSEUDO_WIDTH_PARAM, jpegQuality);
        if (!StringUtils.isEmpty((CharSequence)templateUrl)) {
            templateUrl = templateUrl.replaceAll(String.valueOf(PSEUDO_WIDTH_PARAM), widthPlaceholder);
        }
        return templateUrl;
    }

    public static String getSrc(@NotNull AssetDelivery assetDelivery, @NotNull Resource imageComponentResource, @NotNull String imageName, @NotNull String extension, @Nullable Integer width, @Nullable Integer jpegQuality) {
        Rendition assetRendition;
        Asset asset;
        HashMap<String, Object> params = new HashMap<String, Object>();
        ValueMap componentProperties = imageComponentResource.getValueMap();
        String assetPath = (String)componentProperties.get("fileReference", String.class);
        if (StringUtils.isEmpty((CharSequence)imageName) || StringUtils.isEmpty((CharSequence)assetPath) || StringUtils.isEmpty((CharSequence)extension) || "svg".equalsIgnoreCase(extension)) {
            return null;
        }
        Resource assetResource = imageComponentResource.getResourceResolver().getResource(assetPath);
        if (assetResource == null) {
            return null;
        }
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)componentProperties.get("imageCrop", String.class))) && (asset = (Asset)assetResource.adaptTo(Asset.class)) != null && (assetRendition = asset.getRendition(asset1 -> {
            for (Rendition rendition : asset1.getRenditions()) {
                if (!rendition.getName().startsWith("cq5dam.web")) continue;
                return rendition;
            }
            return null;
        })) != null) {
            try {
                BufferedImage image = ImageIO.read(assetRendition.getStream());
                int imageHeight = image.getHeight();
                int imageWidth = image.getWidth();
                params.put("imageHeight", imageHeight);
                params.put("imageWidth", imageWidth);
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage());
            }
        }
        params.put(PATH_PARAMETER, assetPath);
        params.put(SEO_PARAMETER, imageName);
        params.put(FORMAT_PARAMETER, extension);
        params.put(PREFER_WEBP_PARAMETER, "true");
        if (jpegQuality != null) {
            AssetDeliveryHelper.addQualityParameter(params, jpegQuality);
        }
        if (width != null) {
            AssetDeliveryHelper.addWidthParameter(params, width);
        }
        AssetDeliveryHelper.addCropParameter(params, componentProperties);
        AssetDeliveryHelper.addRotationParameter(params, componentProperties);
        AssetDeliveryHelper.addFlipParameter(params, componentProperties);
        String assetDeliveryURL = assetDelivery.getDeliveryURL(assetResource, params);
        if (!StringUtils.isEmpty((CharSequence)assetDeliveryURL)) {
            return assetDeliveryURL;
        }
        return "";
    }

    private static void addQualityParameter(@NotNull Map<String, Object> params, @NotNull int quality) {
        params.put(QUALITY_PARAMETER, "" + quality);
    }

    private static void addWidthParameter(@NotNull Map<String, Object> params, @NotNull int width) {
        params.put(WIDTH_PARAMETER, "" + width);
    }

    private static void addCropParameter(@NotNull Map<String, Object> params, @NotNull ValueMap componentProperties) {
        String cropParameter = AssetDeliveryHelper.getCropRect(componentProperties, params);
        if (!StringUtils.isEmpty((CharSequence)cropParameter)) {
            params.put(CROP_PARAMETER, cropParameter);
        }
    }

    private static void addRotationParameter(@NotNull Map<String, Object> params, @NotNull ValueMap componentProperties) {
        int rotate = AssetDeliveryHelper.getRotation(componentProperties);
        if (Integer.valueOf(rotate) != null && rotate != 0) {
            params.put(ROTATE_PARAMETER, "" + rotate);
        }
    }

    private static void addFlipParameter(@NotNull Map<String, Object> params, @NotNull ValueMap componentProperties) {
        String flipParameter = AssetDeliveryHelper.getFlip(componentProperties);
        if (!StringUtils.isEmpty((CharSequence)flipParameter)) {
            params.put(FLIP_PARAMETER, flipParameter);
        }
    }

    private static String getCropRect(@NotNull ValueMap properties, Map<String, Object> params) {
        String csv = (String)properties.get("imageCrop", String.class);
        String cropRect = "";
        if (StringUtils.isNotEmpty((CharSequence)csv)) {
            try {
                int ratio = csv.indexOf(47);
                if (ratio >= 0) {
                    csv = csv.substring(0, ratio);
                }
                int imageHeight = (Integer)params.getOrDefault("imageHeight", 0);
                int imageWidth = (Integer)params.getOrDefault("imageWidth", 0);
                String[] coords = csv.split(",");
                double x1 = Integer.parseInt(coords[0]);
                double y1 = Integer.parseInt(coords[1]);
                double x2 = Integer.parseInt(coords[2]);
                double y2 = Integer.parseInt(coords[3]);
                if (imageHeight > 0 && imageWidth > 0) {
                    double width = AssetDeliveryHelper.round((x2 - x1) / (double)imageWidth * 100.0);
                    double height = AssetDeliveryHelper.round((y2 - y1) / (double)imageHeight * 100.0);
                    x1 = AssetDeliveryHelper.round(x1 / (double)imageWidth * 100.0);
                    y1 = AssetDeliveryHelper.round(y1 / (double)imageHeight * 100.0);
                    cropRect = x1 + PERCENTAGE + COMMA + y1 + PERCENTAGE + COMMA + width + PERCENTAGE + COMMA + height + PERCENTAGE;
                } else {
                    double width = AssetDeliveryHelper.round(x2 - x1);
                    double height = AssetDeliveryHelper.round(y2 - y1);
                    cropRect = x1 + COMMA + y1 + COMMA + width + COMMA + height;
                }
            }
            catch (RuntimeException e) {
                LOGGER.warn(String.format("Invalid cropping rectangle %s.", csv), (Throwable)e);
            }
        }
        return cropRect;
    }

    private static double round(double value) {
        int scale = (int)Math.pow(10.0, 1.0);
        return (double)Math.round(value * (double)scale) / (double)scale;
    }

    private static int getRotation(@NotNull ValueMap properties) {
        String rotationString = (String)properties.get("imageRotate", String.class);
        if (rotationString != null) {
            try {
                return Integer.parseInt(rotationString);
            }
            catch (NumberFormatException e) {
                LOGGER.warn(String.format("Invalid rotation value %s.", rotationString), (Throwable)e);
            }
        }
        return 0;
    }

    private static String getFlip(@NotNull ValueMap properties) {
        boolean flipHorizontally = (Boolean)properties.get("imageFlipHorizontal", (Object)Boolean.FALSE);
        boolean flipVertically = (Boolean)properties.get("imageFlipVertical", (Object)Boolean.FALSE);
        if (flipHorizontally && flipVertically) {
            return HORIZONTAL_AND_VERTICAL_FLIP;
        }
        if (flipHorizontally) {
            return HORIZONTAL_FLIP;
        }
        if (flipVertically) {
            return VERTICAL_FLIP;
        }
        return "";
    }
}

