/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.form;

import com.adobe.cq.wcm.core.components.services.form.FormHandler;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.osgi.services.HttpClientBuilderFactory;
import org.json.JSONObject;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FormHandler.class})
@Designate(ocd=Config.class)
public class FormHandlerImpl
implements FormHandler {
    private static final int DEFAULT_CONNECTION_TIMEOUT = 6000;
    private static final int DEFAULT_SOCKET_TIMEOUT = 6000;
    private static final Logger LOG = LoggerFactory.getLogger(FormHandlerImpl.class);
    private static final String CHARSET = "UTF-8";
    private CloseableHttpClient client;
    @Reference
    private HttpClientBuilderFactory clientBuilderFactory;

    @Override
    public boolean forwardFormData(JSONObject formData, String endPointUrl) {
        HttpPost post = new HttpPost(endPointUrl);
        post.setEntity((HttpEntity)new StringEntity(formData.toString(), ContentType.create((String)"application/json", (String)CHARSET)));
        try {
            String response = (String)this.client.execute((HttpUriRequest)post, (ResponseHandler)new BasicResponseHandler());
            LOG.debug("POSTing form data to '{}' succeeded: response: {}", (Object)endPointUrl, (Object)response);
            return true;
        }
        catch (IOException e) {
            LOG.error("POSTing form data to '{}' failed: {}", new Object[]{endPointUrl, e.getMessage(), e});
            return false;
        }
    }

    @Activate
    protected void activate(Config config) {
        int connectionTimeout = config.connectionTimeout();
        if (connectionTimeout < 0) {
            throw new IllegalArgumentException("Connection timeout value cannot be less than 0");
        }
        int socketTimeout = config.socketTimeout();
        if (socketTimeout < 0) {
            throw new IllegalArgumentException("Socket timeout value cannot be less than 0");
        }
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectionTimeout).setConnectionRequestTimeout(connectionTimeout).setSocketTimeout(socketTimeout).build();
        this.client = this.clientBuilderFactory.newBuilder().setDefaultRequestConfig(requestConfig).build();
    }

    @Deactivate
    protected void deactivate() throws IOException {
        this.client.close();
    }

    @ObjectClassDefinition(name="Core Components Form API Client", description="A HTTP Client wrapper for Form API requests")
    public static @interface Config {
        @AttributeDefinition(name="Connection timeout", description="Timeout in milliseconds until a connection is established. A timeout value of zero is interpreted as an infinite timeout. Default is 6000ms", defaultValue={"6000"})
        public int connectionTimeout() default 6000;

        @AttributeDefinition(name="Socket timeout", description="Timeout in milliseconds for waiting for data or a maximum period of inactivity between two consecutive data packets. Default is 6000ms", defaultValue={"6000"})
        public int socketTimeout() default 6000;
    }
}

