/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.forms.core.components.util;

import com.adobe.cq.forms.core.components.models.form.Label;
import com.adobe.cq.forms.core.components.util.ComponentUtils;
import com.day.cq.i18n.I18n;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.Nullable;

public class LabelImpl
implements Label {
    private static final String PN_HIDE_TITLE = "hideTitle";
    private static final String PN_TITLE = "jcr:title";
    private static final String PN_IS_TITLE_RICH_TEXT = "isTitleRichText";
    private ValueMap properties;
    private String defaultTitle;
    private I18n i18n;

    public LabelImpl(Resource field, String defaultTitle, I18n i18n) {
        this.properties = field.getValueMap();
        this.defaultTitle = defaultTitle;
        this.i18n = i18n;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public Boolean isRichText() {
        return (Boolean)this.properties.get(PN_IS_TITLE_RICH_TEXT, Boolean.class);
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public Boolean isVisible() {
        Boolean hideTitle = (Boolean)this.properties.get(PN_HIDE_TITLE, Boolean.class);
        if (hideTitle != null) {
            return hideTitle == false;
        }
        return null;
    }

    @Override
    public String getValue() {
        return ComponentUtils.translate((String)this.properties.get(PN_TITLE, (Object)this.defaultTitle), PN_TITLE, this.properties, this.i18n);
    }
}

