/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.forms.core.components.util;

import com.adobe.aemds.guide.model.CustomPropertyInfo;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.cq.forms.core.components.datalayer.FormComponentData;
import com.adobe.cq.forms.core.components.internal.datalayer.ComponentDataImpl;
import com.adobe.cq.forms.core.components.models.form.BaseConstraint;
import com.adobe.cq.forms.core.components.models.form.FieldType;
import com.adobe.cq.forms.core.components.models.form.FormComponent;
import com.adobe.cq.forms.core.components.models.form.Label;
import com.adobe.cq.forms.core.components.util.AbstractComponentImpl;
import com.adobe.cq.wcm.core.components.util.ComponentUtils;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.WCMMode;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractFormComponentImpl
extends AbstractComponentImpl
implements FormComponent {
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="dataRef")
    @Nullable
    protected String dataRef;
    @ValueMapValue(name="fieldType")
    protected String fieldTypeJcr;
    private FieldType fieldType;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    protected String name;
    @ValueMapValue
    @Default(values={""})
    protected String value;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    protected Boolean visible;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    protected Boolean unboundFormElement;
    @SlingObject
    private Resource resource;
    private Boolean dataLayerEnabled;
    private FormComponentData componentData;
    private static final String STATUS_NONE = "none";
    private static final String STATUS_VALID = "valid";
    private static final String STATUS_INVALID = "invalid";
    private static final String RULES_STATUS_PROP_NAME = "validationStatus";
    private static final String NULL_DATA_REF = "null";
    private static final Logger logger = LoggerFactory.getLogger(AbstractFormComponentImpl.class);
    public static final String CUSTOM_DOR_PROPERTY_WRAPPER = "fd:dor";
    public static final String CUSTOM_JCR_PATH_PROPERTY_WRAPPER = "fd:path";
    public static final String CUSTOM_RULE_PROPERTY_WRAPPER = "fd:rules";
    private final Predicate<Map.Entry<String, Object>> isEntryNonEmpty = obj -> obj.getValue() instanceof String && ((String)obj.getValue()).length() > 0 || obj.getValue() instanceof String[] && ((String[])obj.getValue()).length > 0;

    @PostConstruct
    protected void initBaseModel() {
        this.fieldType = FieldType.fromString(this.fieldTypeJcr);
        if (this.request != null && this.i18n == null) {
            this.i18n = GuideUtils.getI18n((SlingHttpServletRequest)this.request, (Resource)this.resource);
        }
        if (Boolean.TRUE.equals(this.unboundFormElement)) {
            this.dataRef = NULL_DATA_REF;
        }
        this.getName();
    }

    @Override
    public void setI18n(@Nonnull I18n i18n) {
        this.i18n = i18n;
    }

    public BaseConstraint.Type getType() {
        return null;
    }

    public Label getLabel() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public String getLinkUrl() {
        return null;
    }

    public String getTitle() {
        return null;
    }

    public String getText() {
        return null;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.getDefaultName();
        }
        return this.name;
    }

    protected String getDefaultName() {
        return StringEscapeUtils.escapeHtml4((String)GuideUtils.getGuideName((Resource)this.resource));
    }

    @Override
    public String getFieldType() {
        return this.fieldType.getValue();
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public Boolean isVisible() {
        if (this.getEditMode()) {
            return true;
        }
        return this.visible;
    }

    @JsonIgnore
    protected boolean getEditMode() {
        String pathInfo;
        boolean matches;
        boolean editMode = false;
        if (this.request != null && this.request.getPathInfo() != null && !(matches = Pattern.matches(".+model.*\\.json$", pathInfo = this.request.getPathInfo()))) {
            editMode = WCMMode.fromRequest((ServletRequest)this.request) == WCMMode.EDIT || WCMMode.fromRequest((ServletRequest)this.request) == WCMMode.DESIGN;
        }
        return editMode;
    }

    @JsonIgnore
    @NotNull
    public Map<String, Object> getCustomLayoutProperties() {
        LinkedHashMap<String, Object> customLayoutProperties = new LinkedHashMap<String, Object>();
        return customLayoutProperties;
    }

    @Override
    @NotNull
    public Map<String, Object> getProperties() {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        Map<String, String> customProperties = this.getCustomProperties();
        if (customProperties.size() > 0) {
            customProperties.forEach(properties::putIfAbsent);
        }
        if (this.getCustomLayoutProperties().size() != 0) {
            properties.put("afs:layout", this.getCustomLayoutProperties());
        }
        if (this.getDorProperties().size() > 0) {
            properties.put(CUSTOM_DOR_PROPERTY_WRAPPER, this.getDorProperties());
        }
        properties.put(CUSTOM_JCR_PATH_PROPERTY_WRAPPER, this.getPath());
        Map<String, Object> rulesProperties = this.getRulesProperties();
        if (rulesProperties.size() > 0) {
            properties.put(CUSTOM_RULE_PROPERTY_WRAPPER, rulesProperties);
        }
        return properties;
    }

    @Override
    @NotNull
    public Map<String, String> getRules() {
        String[] VALID_RULES = new String[]{"description", "enabled", "enum", "enumNames", "exclusiveMaximum", "exclusiveMinimum", "label", "maximum", "minimum", "readOnly", "required", "value", "visible"};
        Predicate<Map.Entry> isRuleNameValid = obj -> Arrays.stream(VALID_RULES).anyMatch(validKey -> validKey.equals(obj.getKey()));
        Predicate<Map.Entry> isRuleValid = this.isEntryNonEmpty.and(isRuleNameValid);
        Resource ruleNode = this.resource.getChild(CUSTOM_RULE_PROPERTY_WRAPPER);
        if (ruleNode != null) {
            ValueMap ruleNodeProps = ruleNode.getValueMap();
            Map<String, String> rules = ruleNodeProps.entrySet().stream().filter(isRuleValid).map(entry -> new AbstractMap.SimpleEntry<String, String>((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return rules;
        }
        return Collections.emptyMap();
    }

    @JsonIgnore
    private Map<String, Object> getRulesProperties() {
        Resource ruleNode = this.resource.getChild(CUSTOM_RULE_PROPERTY_WRAPPER);
        LinkedHashMap<String, Object> customRulesProperties = new LinkedHashMap<String, Object>();
        String status = this.getRulesStatus(ruleNode);
        if (!STATUS_NONE.equals(status)) {
            customRulesProperties.put(RULES_STATUS_PROP_NAME, this.getRulesStatus(ruleNode));
        }
        return customRulesProperties;
    }

    private String getRulesStatus(Resource rulesResource) {
        if (rulesResource == null) {
            return STATUS_NONE;
        }
        ValueMap props = (ValueMap)rulesResource.adaptTo(ValueMap.class);
        if (props == null) {
            return STATUS_NONE;
        }
        String status = (String)props.get(RULES_STATUS_PROP_NAME, (Object)STATUS_NONE);
        if (!(STATUS_NONE.equals(status) || STATUS_VALID.equals(status) || STATUS_INVALID.equals(status))) {
            status = STATUS_INVALID;
        }
        return status;
    }

    private Stream<Map.Entry<String, String[]>> sanitizeEvent(Map.Entry<String, Object> entry) {
        Stream<Map.Entry<String, String[]>> updatedEntry;
        String[] VALID_EVENTS = new String[]{"click", "submit", "initialize", "load", "change", "submitSuccess", "submitError"};
        Predicate<Map.Entry> isEventNameValid = obj -> ((String)obj.getKey()).startsWith("custom_") || Arrays.stream(VALID_EVENTS).anyMatch(validKey -> validKey.equals(obj.getKey()));
        Predicate<Map.Entry> isEventValid = this.isEntryNonEmpty.and(isEventNameValid);
        Object eventValue = entry.getValue();
        String key = entry.getKey();
        if (key.startsWith("custom_")) {
            key = "custom:" + key.substring("custom_".length());
        }
        if (!isEventValid.test(entry)) {
            updatedEntry = Stream.empty();
        } else {
            String[] arrayEventValue = eventValue instanceof String ? new String[]{(String)eventValue} : (String[])eventValue;
            updatedEntry = Stream.of(new AbstractMap.SimpleEntry<String, String[]>(key, arrayEventValue));
        }
        return updatedEntry;
    }

    @Override
    @NotNull
    public Map<String, String[]> getEvents() {
        Resource eventNode = this.resource.getChild("fd:events");
        HashSet<AbstractMap.SimpleEntry<String, String>> eventSet = new HashSet<AbstractMap.SimpleEntry<String, String>>();
        eventSet.add(new AbstractMap.SimpleEntry<String, String>("custom_setProperty", "$event.payload"));
        if (eventNode != null) {
            ValueMap eventNodeProps = eventNode.getValueMap();
            eventSet.addAll(eventNodeProps.entrySet());
        }
        Map<String, String[]> userEvents = eventSet.stream().flatMap(this::sanitizeEvent).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return userEvents;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonSerialize(using=DataRefSerializer.class)
    @Nullable
    public String getDataRef() {
        return this.dataRef;
    }

    @Override
    @JsonIgnore
    public String getPath() {
        if (this.resource != null) {
            return this.resource.getPath();
        }
        return "";
    }

    @Override
    @NotNull
    protected FormComponentData getComponentData() {
        return new ComponentDataImpl(this, this.resource);
    }

    @Override
    @Nullable
    public FormComponentData getData() {
        if (this.componentData == null) {
            if (this.dataLayerEnabled == null) {
                this.dataLayerEnabled = this.getCurrentPage() != null ? Boolean.valueOf(ComponentUtils.isDataLayerEnabled((Resource)this.getCurrentPage().getContentResource())) : Boolean.valueOf(ComponentUtils.isDataLayerEnabled((Resource)this.resource));
            }
            if (this.dataLayerEnabled.booleanValue()) {
                this.componentData = this.getComponentData();
            }
        }
        return this.componentData;
    }

    private Map<String, String> getCustomProperties() {
        try {
            return Optional.ofNullable((CustomPropertyInfo)this.resource.adaptTo(CustomPropertyInfo.class)).map(CustomPropertyInfo::getProperties).orElse(Collections.emptyMap());
        }
        catch (NoClassDefFoundError e) {
            logger.info("CustomPropertyInfo class not found. This feature is available in the latest Forms addon. Returning an empty map.");
            return Collections.emptyMap();
        }
    }

    private static class DataRefSerializer
    extends JsonSerializer<String> {
        private DataRefSerializer() {
        }

        public void serialize(String s, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (AbstractFormComponentImpl.NULL_DATA_REF.equals(s)) {
                jsonGenerator.writeString((String)null);
            } else {
                jsonGenerator.writeString(s);
            }
        }

        public boolean isEmpty(SerializerProvider provider, String value) {
            return StringUtils.isEmpty((CharSequence)value);
        }
    }
}

