/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.forms.core.components.util;

import com.adobe.cq.forms.core.components.models.form.Field;
import com.adobe.cq.forms.core.components.util.AbstractBaseImpl;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFieldImpl
extends AbstractBaseImpl
implements Field {
    private static final Logger logger = LoggerFactory.getLogger(AbstractFieldImpl.class);
    private static final String PN_PLACEHOLDER = "placeholder";
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    protected Boolean readOnly;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="default")
    @Nullable
    protected Object[] defaultValue;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="placeholder")
    @Nullable
    protected String placeholder;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="displayFormat")
    @Nullable
    protected String displayFormat;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="editFormat")
    @Nullable
    protected String editFormat;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="dataFormat")
    @Nullable
    protected String dataFormat;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="minLength")
    @Nullable
    protected Integer minLength;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="maxLength")
    @Nullable
    protected Integer maxLength;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="maximum")
    @Nullable
    protected Long maximum;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="minimum")
    @Nullable
    protected Long minimum;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="minimumDate")
    @Nullable
    protected Date minimumDate;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="maximumDate")
    @Nullable
    protected Date maximumDate;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="exclusiveMinimum")
    @Nullable
    protected Long exclusiveMinimum;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="exclusiveMaximum")
    @Nullable
    protected Long exclusiveMaximum;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="exclusiveMinimumDate")
    @Nullable
    protected Date exclusiveMinimumDate;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="exclusiveMaximumDate")
    @Nullable
    protected Date exclusiveMaximumDate;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="dorExclusion")
    @Default(booleanValues={false})
    protected boolean dorExclusion;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="dorColspan")
    @Nullable
    protected String dorColspan;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="dorBindRef")
    @Nullable
    protected String dorBindRef;
    @SlingObject
    private Resource resource;

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public Boolean isRequired() {
        return this.required;
    }

    @Override
    public Object[] getDefault() {
        if (this.defaultValue != null) {
            return Arrays.stream(this.defaultValue).map(p -> {
                if (p instanceof Calendar) {
                    return ((Calendar)p).getTime();
                }
                return p;
            }).toArray();
        }
        return null;
    }

    @Override
    @Nullable
    public String getPlaceHolder() {
        return this.translate(PN_PLACEHOLDER, this.placeholder);
    }

    @Override
    @Nullable
    public String getDisplayFormat() {
        return this.displayFormat;
    }

    @Override
    @Nullable
    public String getEditFormat() {
        return this.editFormat;
    }

    @Override
    @Nullable
    public String getDataFormat() {
        return this.dataFormat;
    }

    @Override
    @JsonIgnore
    public Map<String, Object> getDorProperties() {
        LinkedHashMap<String, Object> customDorProperties = new LinkedHashMap<String, Object>();
        customDorProperties.put("dorExclusion", this.dorExclusion);
        if (this.dorColspan != null) {
            customDorProperties.put("dorColspan", this.dorColspan);
        }
        if (this.dorBindRef != null) {
            customDorProperties.put("dorBindRef", this.dorBindRef);
        }
        return customDorProperties;
    }
}

