/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.forms.core.components.util;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.export.json.SlingModelFilter;
import com.adobe.cq.forms.core.components.models.form.Base;
import com.adobe.cq.forms.core.components.models.form.Container;
import com.adobe.cq.forms.core.components.models.form.ContainerConstraint;
import com.adobe.cq.forms.core.components.util.AbstractBaseImpl;
import com.day.cq.wcm.foundation.model.export.AllowedComponentsExporter;
import com.day.cq.wcm.foundation.model.responsivegrid.ResponsiveGrid;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.factory.ModelFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractContainerImpl
extends AbstractBaseImpl
implements Container,
ContainerConstraint {
    @OSGiService
    private SlingModelFilter slingModelFilter;
    @OSGiService
    private ModelFactory modelFactory;
    @SlingObject
    protected Resource resource;
    protected List<? extends ComponentExporter> childrenModels;
    protected Map<String, ? extends ComponentExporter> itemModels;
    protected List<Resource> filteredChildComponents;
    private String[] exportedItemsOrder;
    @Nullable
    protected ResponsiveGrid resGrid = null;

    @Override
    public Boolean isRepeatable() {
        return this.repeatable;
    }

    @Override
    public Integer getMinOccur() {
        return this.minOccur;
    }

    @Override
    public Integer getMaxOccur() {
        return this.maxOccur;
    }

    @Override
    public Integer getMinItems() {
        return this.minItems;
    }

    @Override
    public Integer getMaxItems() {
        return this.maxItems;
    }

    @Override
    @PostConstruct
    protected void initBaseModel() {
        super.initBaseModel();
        if (this.request != null && this.resource.isResourceType("wcm/foundation/components/responsivegrid")) {
            this.resGrid = (ResponsiveGrid)this.request.adaptTo(ResponsiveGrid.class);
        }
    }

    @Override
    public List<? extends ComponentExporter> getItems() {
        if (this.childrenModels == null) {
            this.childrenModels = new ArrayList<ComponentExporter>(this.getChildrenModels(this.request, ComponentExporter.class).values());
        }
        return this.childrenModels;
    }

    @Override
    @NotNull
    public String[] getExportedItemsOrder() {
        if (this.exportedItemsOrder == null) {
            Map<String, ? extends ComponentExporter> models = this.getExportedItems();
            this.exportedItemsOrder = !models.isEmpty() ? models.keySet().toArray(ArrayUtils.EMPTY_STRING_ARRAY) : ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return Arrays.copyOf(this.exportedItemsOrder, this.exportedItemsOrder.length);
    }

    protected <T> Map<String, T> getChildrenModels(@Nullable SlingHttpServletRequest request, @NotNull Class<T> modelClass) {
        List<Resource> filteredChildrenResources = this.getFilteredChildrenResources();
        return this.getChildrenModels(request, modelClass, filteredChildrenResources);
    }

    protected <T> Map<String, T> getChildrenModels(@Nullable SlingHttpServletRequest request, @NotNull Class<T> modelClass, List<Resource> filteredChildrenResources) {
        LinkedHashMap<String, Object> models = new LinkedHashMap<String, Object>();
        for (Resource child : filteredChildrenResources) {
            Object model = null;
            if (request != null) {
                model = this.modelFactory.getModelFromWrappedRequest(request, child, modelClass);
            } else {
                model = child.adaptTo(modelClass);
                if (model instanceof Base && this.i18n != null) {
                    ((Base)model).setI18n(this.i18n);
                }
            }
            if (model == null) continue;
            models.put(child.getName(), model);
        }
        return models;
    }

    @Override
    @NotNull
    public Map<String, ? extends ComponentExporter> getExportedItems() {
        if (this.itemModels == null) {
            this.itemModels = this.getChildrenModels(this.request, ComponentExporter.class);
        }
        return this.itemModels;
    }

    protected List<Resource> getFilteredChildrenResources() {
        return this.getFilteredChildrenResources(this.resource);
    }

    protected List<Resource> getFilteredChildrenResources(Resource containerResource) {
        if (this.filteredChildComponents == null) {
            this.filteredChildComponents = new LinkedList<Resource>();
            if (containerResource != null) {
                for (Resource child : this.slingModelFilter.filterChildResources(containerResource.getChildren())) {
                    if (child.getName().startsWith("fd:")) continue;
                    this.filteredChildComponents.add(child);
                }
            }
        }
        return this.filteredChildComponents;
    }

    @Override
    @Nullable
    public String getGridClassNames() {
        if (this.resGrid != null) {
            return this.resGrid.getGridClassNames();
        }
        return null;
    }

    @Override
    @Nonnull
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, String> getColumnClassNames() {
        if (this.resGrid != null) {
            return this.resGrid.getColumnClassNames();
        }
        return Collections.emptyMap();
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public int getColumnCount() {
        if (this.resGrid != null) {
            return this.resGrid.getColumnCount();
        }
        return 0;
    }

    @Override
    public AllowedComponentsExporter getExportedAllowedComponents() {
        if (this.resGrid != null) {
            return this.resGrid.getExportedAllowedComponents();
        }
        return null;
    }
}

