/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.forms.core.components.internal.servlets;

import com.adobe.aemds.guide.model.FormMetaData;
import com.adobe.cq.forms.core.components.internal.servlets.AbstractDataSourceServlet;
import com.adobe.cq.forms.core.components.util.ComponentUtils;
import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.ExpressionResolver;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import com.adobe.granite.ui.components.ds.ValueMapResource;
import com.day.cq.wcm.api.policies.ContentPolicy;
import com.day.cq.wcm.foundation.forms.FormsManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=core/fd/components/form/container/v1/datasource", "sling.servlet.methods=GET", "sling.servlet.extensions=html"})
public class FormMetaDataDataSourceServlet
extends AbstractDataSourceServlet {
    private static final String TYPE = "type";
    private static final String DATA_MODEL = "guideDataModel";
    private static final String FIELD_TYPE = "fieldType";
    private static final String ALLOWED_FORMAT = "allowedFormat";
    private static final String ALLOWED_CUSTOM_FORMAT = "allowedCustomFormats";
    private static final String CUSTOM_FORMAT_KEY = "customFormatKey";
    private static final String CUSTOM_FORMAT_VALUE = "customFormatValue";
    private static final String NN_DIALOG = "cq:dialog";
    @Reference
    private transient ExpressionResolver expressionResolver;

    @Override
    @NotNull
    protected ExpressionResolver getExpressionResolver() {
        return this.expressionResolver;
    }

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        Config config = this.getConfig(request);
        SimpleDataSource actionTypeDataSource = null;
        if (config != null) {
            FormMetaDataType type = FormMetaDataType.fromString(this.getParameter(config, TYPE, request, null));
            String dataModel = this.getParameter(config, DATA_MODEL, request, "");
            actionTypeDataSource = new SimpleDataSource(this.getDataSourceResources((HttpServletRequest)request, request.getResourceResolver(), type, dataModel).iterator());
        }
        request.setAttribute(DataSource.class.getName(), actionTypeDataSource);
    }

    private List<Resource> getDataSourceResources(HttpServletRequest request, ResourceResolver resourceResolver, FormMetaDataType type, String dataModel) {
        List<Resource> resources = new ArrayList<Resource>();
        FormMetaData formMetaData = (FormMetaData)resourceResolver.adaptTo(FormMetaData.class);
        if (formMetaData != null) {
            Iterator<FormsManager.ComponentDescription> metaDataList = null;
            switch (type) {
                case FORMATTERS: {
                    ContentPolicy policy = ComponentUtils.getPolicy((String)request.getAttribute("granite.ui.form.contentpath"), resourceResolver);
                    resources.add((Resource)this.getResourceForDropdownDisplay(resourceResolver, "Select", ""));
                    if (policy != null) {
                        ValueMap props = policy.getProperties();
                        if (props != null) {
                            for (Map.Entry entry : props.entrySet()) {
                                if (!((String)entry.getKey()).startsWith(ALLOWED_FORMAT)) continue;
                                String[] arr = entry.getValue().toString().split("=", 2);
                                resources.add((Resource)this.getResourceForDropdownDisplay(resourceResolver, arr[0], arr[1]));
                            }
                        }
                        Map<String, String> allowedCustomFormattersMap = this.getAllowedCustomFormatters(policy, resourceResolver);
                        for (Map.Entry<String, String> entry : allowedCustomFormattersMap.entrySet()) {
                            resources.add((Resource)this.getResourceForDropdownDisplay(resourceResolver, entry.getKey(), entry.getValue()));
                        }
                    }
                    resources.add((Resource)this.getResourceForDropdownDisplay(resourceResolver, "Custom", "custom"));
                    break;
                }
                case SUBMIT_ACTION: {
                    HashSet uniques = new HashSet();
                    metaDataList = StreamSupport.stream(Spliterators.spliteratorUnknownSize(formMetaData.getSubmitActions(), 16), false).filter(e -> uniques.add(e.getResourceType())).filter(e -> ((String)resourceResolver.getResource(e.getResourceType()).getValueMap().get(DATA_MODEL, (Object)"")).toLowerCase().contains(dataModel.toLowerCase())).collect(Collectors.toList()).iterator();
                    resources = this.getResourceListFromComponentDescription(metaDataList, resourceResolver);
                    break;
                }
                case PREFILL_ACTION: {
                    metaDataList = formMetaData.getPrefillActions();
                    resources = this.getResourceListFromComponentDescription(metaDataList, resourceResolver);
                }
            }
        }
        return resources;
    }

    private Map<String, String> getAllowedCustomFormatters(ContentPolicy policy, ResourceResolver resourceResolver) {
        Resource policyResource = resourceResolver.resolve(policy.getPath());
        HashMap<String, String> allowedCustomFormattersMap = new HashMap<String, String>();
        List<Resource> allowedcustomFormattersResourceList = StreamSupport.stream(policyResource.getChildren().spliterator(), false).filter(childResource -> childResource.getName().equals(ALLOWED_CUSTOM_FORMAT)).collect(Collectors.toList());
        allowedcustomFormattersResourceList.forEach(allowedcustomFormattersResource -> allowedcustomFormattersResource.getChildren().forEach(allowedCustomFormatters -> {
            String customFormatKey = "";
            String customFormatValue = "";
            for (Map.Entry entry : allowedCustomFormatters.getValueMap().entrySet()) {
                if (((String)entry.getKey()).equals(CUSTOM_FORMAT_KEY)) {
                    customFormatKey = entry.getValue().toString();
                    continue;
                }
                if (!((String)entry.getKey()).equals(CUSTOM_FORMAT_VALUE)) continue;
                customFormatValue = entry.getValue().toString();
            }
            if (!customFormatKey.isEmpty() && !customFormatValue.isEmpty()) {
                allowedCustomFormattersMap.put(customFormatKey, customFormatValue);
            }
        }));
        return allowedCustomFormattersMap;
    }

    private SyntheticResource getResourceForDropdownDisplay(ResourceResolver resourceResolver, String key, String value) {
        HashMap<String, String> dropdownMap = new HashMap<String, String>();
        dropdownMap.put("text", key);
        dropdownMap.put("value", value);
        ValueMapDecorator dropdownEntryVm = new ValueMapDecorator(dropdownMap);
        return new ValueMapResource(resourceResolver, "", "nt:unstructured", (ValueMap)dropdownEntryVm);
    }

    private List<Resource> getResourceListFromComponentDescription(Iterator<FormsManager.ComponentDescription> metaDataList, ResourceResolver resourceResolver) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (metaDataList != null) {
            while (metaDataList.hasNext()) {
                FormsManager.ComponentDescription description = metaDataList.next();
                Resource syntheticResource = this.createResource(resourceResolver, description);
                resources.add(syntheticResource);
            }
        }
        return resources;
    }

    public static enum FormMetaDataType {
        SUBMIT_ACTION("submitAction"),
        PREFILL_ACTION("prefillServiceProvider"),
        FORMATTERS("formatters");

        private String value;

        private FormMetaDataType(String value) {
            this.value = value;
        }

        public static FormMetaDataType fromString(String value) {
            for (FormMetaDataType type : FormMetaDataType.values()) {
                if (!StringUtils.equals((CharSequence)value, (CharSequence)type.value)) continue;
                return type;
            }
            return null;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }
}

