/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.forms.core.components.internal.models.v1.form;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.export.json.SlingModelFilter;
import com.adobe.cq.forms.core.components.internal.models.v1.form.PanelImpl;
import com.adobe.cq.forms.core.components.models.form.FormClientLibManager;
import com.adobe.cq.forms.core.components.models.form.FormContainer;
import com.adobe.cq.forms.core.components.models.form.Fragment;
import com.adobe.cq.forms.core.components.util.ComponentUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.apache.sling.models.factory.ModelFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class}, adapters={Fragment.class, ComponentExporter.class}, resourceType={"core/fd/components/form/fragment/v1/fragment"})
@Exporter(name="jackson", extensions={"json"})
public class FragmentImpl
extends PanelImpl
implements Fragment {
    public static final String CUSTOM_FRAGMENT_PROPERTY_WRAPPER = "fd:fragment";
    @OSGiService
    private SlingModelFilter slingModelFilter;
    @OSGiService
    private ModelFactory modelFactory;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    private String fragmentPath;
    private Resource fragmentContainer;

    @PostConstruct
    private void initFragmentModel() {
        ResourceResolver resourceResolver = this.resource.getResourceResolver();
        this.fragmentContainer = ComponentUtils.getFragmentContainer(resourceResolver, this.fragmentPath);
        if (this.request != null) {
            FormClientLibManager formClientLibManager = (FormClientLibManager)this.request.adaptTo(FormClientLibManager.class);
            String clientLibRef = this.getClientLibForFragment();
            if (formClientLibManager != null && clientLibRef != null) {
                formClientLibManager.addClientLibRef(clientLibRef);
            }
        }
    }

    @Override
    @JsonIgnore
    public String getFragmentPath() {
        return this.fragmentPath;
    }

    @Override
    @NotNull
    public Map<String, ? extends ComponentExporter> getExportedItems() {
        if (this.itemModels == null) {
            this.itemModels = this.getChildrenModels(this.request, ComponentExporter.class);
        }
        return this.itemModels;
    }

    @Override
    protected <T> Map<String, T> getChildrenModels(@Nullable SlingHttpServletRequest request, @NotNull Class<T> modelClass) {
        List<Resource> filteredChildrenResources = this.getFilteredChildrenResources(this.fragmentContainer);
        SlingHttpServletRequestWrapper wrappedSlingHttpServletRequest = null;
        if (request != null) {
            wrappedSlingHttpServletRequest = new SlingHttpServletRequestWrapper(request){

                public Object getAttribute(String attrName) {
                    if ("resourceCallerPath".equals(attrName)) {
                        String resourceCallerPath = (String)super.getAttribute("resourceCallerPath");
                        return resourceCallerPath != null ? resourceCallerPath : FragmentImpl.this.resource.getPath();
                    }
                    return super.getAttribute(attrName);
                }
            };
        }
        return this.getChildrenModels((SlingHttpServletRequest)wrappedSlingHttpServletRequest, modelClass, filteredChildrenResources);
    }

    @Override
    @JsonIgnore
    public List<Resource> getFragmentChildren() {
        if (this.filteredChildComponents == null) {
            this.filteredChildComponents = this.getFilteredChildrenResources(this.fragmentContainer);
        }
        return this.filteredChildComponents;
    }

    @JsonIgnore
    public String getFragmentTitle() {
        Resource jcrContentRes;
        String fragmentTitle = "";
        if (this.fragmentContainer != null && (jcrContentRes = this.fragmentContainer.getParent()) != null) {
            ValueMap vm = jcrContentRes.getValueMap();
            fragmentTitle = (String)vm.get("jcr:title", (Object)"");
        }
        return fragmentTitle;
    }

    @JsonIgnore
    public List<String> getTitleListOfChildren() {
        ArrayList<String> titleList = new ArrayList<String>();
        if (this.filteredChildComponents == null) {
            this.filteredChildComponents = this.getFilteredChildrenResources(this.fragmentContainer);
        }
        for (Resource child : this.filteredChildComponents) {
            ValueMap vm = child.getValueMap();
            titleList.add((String)vm.get("jcr:title", (Object)""));
        }
        return titleList;
    }

    @Override
    public Map<String, Object> getProperties() {
        Map<String, Object> properties = super.getProperties();
        properties.put(CUSTOM_FRAGMENT_PROPERTY_WRAPPER, true);
        return properties;
    }

    private String getClientLibForFragment() {
        String clientLibRef = null;
        if (this.fragmentContainer != null) {
            FormContainer fragment = (FormContainer)this.fragmentContainer.adaptTo(FormContainer.class);
            clientLibRef = fragment != null ? fragment.getClientLibRef() : null;
        }
        return clientLibRef;
    }
}

