/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.forms.core.components.internal.models.v1.form;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.export.json.ContainerExporter;
import com.adobe.cq.forms.core.components.internal.models.v1.form.FormMetaDataImpl;
import com.adobe.cq.forms.core.components.models.form.FormContainer;
import com.adobe.cq.forms.core.components.models.form.FormMetaData;
import com.adobe.cq.forms.core.components.util.AbstractComponentImpl;
import com.adobe.cq.forms.core.components.util.ComponentUtils;
import com.day.cq.dam.api.Asset;
import com.day.cq.wcm.foundation.model.export.AllowedComponentsExporter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class}, adapters={FormContainer.class, ContainerExporter.class, ComponentExporter.class}, resourceType={"core/fd/components/form/container/v1/container"})
@Exporter(name="jackson", extensions={"json"})
public class FormContainerImpl
extends AbstractComponentImpl
implements FormContainer {
    private static final Logger logger = LoggerFactory.getLogger(FormContainerImpl.class);
    @SlingObject
    private Resource resource;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String thankyouMessage;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String title;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String description;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String data;
    @ValueMapValue(name="formModelDocumentPath", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(values={""})
    protected String documentPath;

    @Override
    @JsonIgnore
    public String getId() {
        return super.getId();
    }

    @Override
    public FormMetaData getMetaData() {
        return new FormMetaDataImpl();
    }

    @Override
    @Nullable
    public String getTitle() {
        return this.title;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public String getThankYouMessage() {
        return this.translate("thankyouMessage", this.thankyouMessage);
    }

    @Override
    @Nullable
    public String getFormData() {
        return this.data;
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.resource.getResourceType();
    }

    @Override
    @JsonIgnore
    public String getDocumentPath() {
        return this.documentPath;
    }

    @Override
    @JsonIgnore
    public String getEncodedCurrentPagePath() {
        if (this.getCurrentPage() != null) {
            return ComponentUtils.getEncodedPath(this.getCurrentPage().getPath());
        }
        return null;
    }

    @Override
    @JsonIgnore
    public List<? extends ComponentExporter> getItems() {
        return Collections.emptyList();
    }

    @Override
    @JsonIgnore
    public Map<String, Object> getModel() {
        Map jsonMap = null;
        if (StringUtils.isNotEmpty((CharSequence)this.documentPath) && this.request != null && this.request.getResourceResolver().getResource(this.documentPath) != null) {
            Resource assetResource = this.request.getResourceResolver().getResource(this.documentPath);
            if (assetResource != null) {
                Asset asset = (Asset)assetResource.adaptTo(Asset.class);
                if (asset != null) {
                    try {
                        InputStream inputStream = asset.getOriginal().getStream();
                        ObjectMapper mapper = new ObjectMapper();
                        jsonMap = (Map)mapper.readValue(inputStream, Map.class);
                    }
                    catch (IOException e) {
                        logger.error("Unable to read json from resource '{}'", (Object)this.documentPath);
                    }
                } else {
                    logger.error("Unable to adapt resource '{}' used by form container '{}' to an asset.", (Object)this.documentPath, (Object)this.resource.getPath());
                }
            }
        } else {
            FormContainer formContainer = (FormContainer)this.resource.adaptTo(FormContainer.class);
            ObjectMapper mapper = new ObjectMapper();
            jsonMap = (Map)mapper.convertValue((Object)formContainer, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        return jsonMap;
    }

    @Override
    @Nullable
    public String getGridClassNames() {
        return null;
    }

    @Override
    @Nonnull
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, String> getColumnClassNames() {
        return Collections.emptyMap();
    }

    @Override
    public int getColumnCount() {
        return 0;
    }

    @Override
    @Nullable
    public AllowedComponentsExporter getExportedAllowedComponents() {
        return null;
    }
}

