/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.forms.core.components.internal.form;

import com.adobe.cq.forms.core.components.models.form.FormContainer;
import com.adobe.cq.forms.core.components.models.form.FormStructureParser;
import com.adobe.cq.forms.core.components.util.ComponentUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class}, adapters={FormStructureParser.class})
public class FormStructureParserImpl
implements FormStructureParser {
    @SlingObject(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private SlingHttpServletRequest request;
    @SlingObject
    private Resource resource;

    @Override
    public String getFormContainerPath() {
        return this.getFormContainerPath(this.resource);
    }

    @Override
    public String getThemeClientLibRefFromFormContainer() {
        FormContainer formContainer = this.getFormContainer(this.resource);
        return formContainer != null ? formContainer.getThemeClientLibRef() : null;
    }

    @Override
    public String getClientLibRefFromFormContainer() {
        FormContainer formContainer = this.getFormContainer(this.resource);
        return formContainer != null ? formContainer.getClientLibRef() : null;
    }

    @Override
    public Boolean containsFormContainer() {
        return this.containsFormContainer(this.resource);
    }

    private Boolean containsFormContainer(Resource resource) {
        if (resource == null) {
            return false;
        }
        if (ComponentUtils.isAFContainer(resource)) {
            return true;
        }
        for (Resource child : resource.getChildren()) {
            if (!this.containsFormContainer(child).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private FormContainer getFormContainer(@Nullable Resource resource) {
        if (resource == null) {
            return null;
        }
        if (ComponentUtils.isAFContainer(resource)) {
            FormContainer formContainer = (FormContainer)resource.adaptTo(FormContainer.class);
            return formContainer;
        }
        for (Resource child : resource.getChildren()) {
            FormContainer formContainer = this.getFormContainer(child);
            if (formContainer == null) continue;
            return formContainer;
        }
        return null;
    }

    private String getFormContainerPath(Resource resource) {
        if (this.request != null && this.request.getAttribute("formContainerPath") != null) {
            return (String)this.request.getAttribute("formContainerPath");
        }
        if (resource == null) {
            return null;
        }
        if (ComponentUtils.isAFContainer(resource)) {
            return resource.getPath();
        }
        return this.getFormContainerPath(resource.getParent());
    }
}

