/*
 * Decompiled with CFR 0.152.
 */
package com.aemforms.assembletaskattachments.core;

import com.adobe.aemfd.docmanager.Document;
import com.adobe.fd.assembler.client.AssemblerOptionSpec;
import com.adobe.fd.assembler.client.AssemblerResult;
import com.adobe.fd.assembler.client.OperationException;
import com.adobe.fd.assembler.service.AssemblerService;
import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.SearchResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Component(property={"service.description=AssembleTaskAttachments", "service.vendor=Adobe Systems", "process.label=Assemble task attachments in the specified order"})
public class AssembleTaskAttachmentsInOrder
implements WorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(AssembleTaskAttachmentsInOrder.class);
    @Reference
    QueryBuilder queryBuilder;
    @Reference
    AssemblerService assemblerService;

    public Map<String, Object> createMapOfDocuments(String payloadPath, WorkflowSession workflowSession) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        HashMap<String, Object> mapOfDocuments = new HashMap<String, Object>();
        queryMap.put("type", "nt:file");
        queryMap.put("path", payloadPath);
        Query query = this.queryBuilder.createQuery(PredicateGroup.create(queryMap), (Session)workflowSession.adaptTo(Session.class));
        query.setStart(0L);
        query.setHitsPerPage(100L);
        SearchResult result = query.getResult();
        log.debug("Get result hits " + result.getHits().size());
        for (Hit hit : result.getHits()) {
            try {
                String path = hit.getPath();
                log.debug("The title " + hit.getTitle() + " path " + path);
                if (!hit.getTitle().endsWith("pdf")) continue;
                Node attachmentNode = ((Session)workflowSession.adaptTo(Session.class)).getNode(path + "/jcr:content");
                InputStream pdfDocumentStream = attachmentNode.getProperty("jcr:data").getBinary().getStream();
                Document attachmentDocument = new Document(pdfDocumentStream);
                mapOfDocuments.put(hit.getTitle(), attachmentDocument);
                log.debug("@@@@Added to map@@@@@ " + hit.getTitle());
            }
            catch (Exception e) {
                log.debug(e.getMessage());
            }
        }
        return mapOfDocuments;
    }

    public Document createDDX(org.w3c.dom.Document xmlDocument, String[] tagNames) {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        org.w3c.dom.Document ddx = null;
        log.debug("In createDDXFromMapOfDocuments The number of tags I got was " + tagNames.length);
        try {
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            ddx = docBuilder.newDocument();
            Element rootElement = ddx.createElementNS("http://ns.adobe.com/DDX/1.0/", "DDX");
            ddx.appendChild(rootElement);
            Element pdfResult = ddx.createElement("PDF");
            pdfResult.setAttribute("result", "GeneratedDocument.pdf");
            rootElement.appendChild(pdfResult);
            for (int j = 0; j < tagNames.length; ++j) {
                String tagName = tagNames[j];
                log.debug("The tag name is " + tagName);
                NodeList tags = xmlDocument.getElementsByTagName(tagName);
                for (int i = 0; i < tags.getLength(); ++i) {
                    log.debug("The tag name is " + tagName);
                    NodeList nl = tags.item(i).getChildNodes();
                    for (int k = 0; k < nl.getLength(); ++k) {
                        log.debug("The node type is " + nl.item(k).getNodeType() + nl.item(k).getNodeName() + nl.item(k).getTextContent());
                        if (nl.item(k).getNodeType() != 1) continue;
                        log.debug("Adding pdf source " + nl.item(k).getTextContent());
                        Element pdfSourceElement = ddx.createElement("PDF");
                        Element noForms = ddx.createElement("NoForms");
                        pdfSourceElement.setAttribute("bookmarkTitle", nl.item(k).getTextContent());
                        pdfSourceElement.setAttribute("source", nl.item(k).getTextContent());
                        pdfSourceElement.appendChild(noForms);
                        pdfResult.appendChild(pdfSourceElement);
                    }
                }
            }
        }
        catch (Exception e) {
            log.debug(e.getMessage());
        }
        return this.orgw3cDocumentToAEMFDDocument(ddx);
    }

    public Document orgw3cDocumentToAEMFDDocument(org.w3c.dom.Document xmlDocument) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DOMSource source = new DOMSource(xmlDocument);
        log.debug("$$$$In orgW3CDocumentToAEMFDDocument method");
        StreamResult outputTarget = new StreamResult(outputStream);
        try {
            TransformerFactory.newInstance().newTransformer().transform(source, outputTarget);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        ByteArrayInputStream is1 = new ByteArrayInputStream(outputStream.toByteArray());
        Document xmlAEMFDDocument = new Document((InputStream)is1);
        if (log.isDebugEnabled()) {
            try {
                xmlAEMFDDocument.copyToFile(new File("ddx.xml"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return xmlAEMFDDocument;
    }

    private Document assembleDocuments(Map<String, Object> mapOfDocuments, Document ddxDocument) {
        AssemblerOptionSpec aoSpec = new AssemblerOptionSpec();
        aoSpec.setFailOnError(true);
        AssemblerResult ar = null;
        try {
            ar = this.assemblerService.invoke(ddxDocument, mapOfDocuments, aoSpec);
            return (Document)ar.getDocuments().get("GeneratedDocument.pdf");
        }
        catch (OperationException e) {
            log.debug(e.getMessage());
            return null;
        }
    }

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap arg2) throws WorkflowException {
        String[] attachmentNames = ((String)arg2.get("PROCESS_ARGS", (Object)"string")).toString().split(",");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("path", workItem.getWorkflowData().getPayload().toString());
        log.debug("The payload path is " + workItem.getWorkflowData().getPayload().toString());
        String payloadPath = workItem.getWorkflowData().getPayload().toString();
        log.debug("The payload path is " + workItem.getWorkflowData().getPayload().toString());
        String dataFilePath = payloadPath + "/Data.xml/jcr:content";
        Session session = (Session)workflowSession.adaptTo(Session.class);
        DocumentBuilderFactory factory = null;
        DocumentBuilder builder = null;
        org.w3c.dom.Document xmlDocument = null;
        Node xmlDataNode = null;
        try {
            xmlDataNode = session.getNode(dataFilePath);
            InputStream xmlDataStream = xmlDataNode.getProperty("jcr:data").getBinary().getStream();
            log.debug("Got InputStream.... and the size available is ..." + xmlDataStream.available());
            factory = DocumentBuilderFactory.newInstance();
            builder = factory.newDocumentBuilder();
            xmlDocument = builder.parse(xmlDataStream);
            Document ddxDocument = this.createDDX(xmlDocument, attachmentNames);
            Document assembledDocument = this.assembleDocuments(this.createMapOfDocuments(payloadPath, workflowSession), ddxDocument);
            if (log.isDebugEnabled()) {
                assembledDocument.copyToFile(new File("assembled-pdf.pdf"));
            }
            Node payloadNode = ((Session)workflowSession.adaptTo(Session.class)).getNode(workItem.getWorkflowData().getPayload().toString());
            log.debug("The payload Path is " + payloadNode.getPath());
            Node assembledPDFNode = payloadNode.addNode("assembled-pdf.pdf", "nt:file");
            Node jcrContentNode = assembledPDFNode.addNode("jcr:content", "nt:resource");
            Binary binary = session.getValueFactory().createBinary(assembledDocument.getInputStream());
            jcrContentNode.setProperty("jcr:data", binary);
            log.debug("Saved !!!!!!");
            session.save();
        }
        catch (Exception e1) {
            log.debug(e1.getMessage());
        }
    }
}

