/*
 * Decompiled with CFR 0.152.
 */
package com.aemforms.dbsamples.core.insertFormData;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.aemforms.dbsamples.core.insertFormData.InsertFormDataConfigurationService;
import com.day.commons.datasource.poolservice.DataSourcePool;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.description=Insert Form Data in Database", "service.vendor=Adobe Systems", "process.label=Insert Form Data in Database"})
public class InsertAfData
implements WorkflowProcess {
    @Reference
    InsertFormDataConfigurationService insertFormDataConfig;
    @Reference
    DataSourcePool dataSourcePool;

    public void execute(WorkItem workItem, WorkflowSession session, MetaDataMap metaDataMap) throws WorkflowException {
        System.out.println("The data source name is " + this.insertFormDataConfig.getDATA_SOURCE_NAME());
        String proccesArgsVals = (String)metaDataMap.get("PROCESS_ARGS", (Object)"string");
        String[] values = proccesArgsVals.split(",");
        String AdaptiveFormName = values[0];
        String formDataFile = values[1];
        String payloadPath = workItem.getWorkflowData().getPayload().toString();
        Session jcrSession = (Session)session.adaptTo(Session.class);
        String dataFilePath = payloadPath + "/" + formDataFile + "/jcr:content";
        System.out.println("The data file path is " + dataFilePath);
        PreparedStatement ps = null;
        Connection con = null;
        DataSource dbSource = null;
        try {
            dbSource = (DataSource)this.dataSourcePool.getDataSource(this.insertFormDataConfig.getDATA_SOURCE_NAME());
            System.out.println("Got db source");
            con = dbSource.getConnection();
            Node xmlDataNode = jcrSession.getNode(dataFilePath);
            InputStream xmlDataStream = xmlDataNode.getProperty("jcr:data").getBinary().getStream();
            StringWriter writer = new StringWriter();
            String encoding = StandardCharsets.UTF_8.name();
            IOUtils.copy((InputStream)xmlDataStream, (Writer)writer, (String)encoding);
            String queryStmt = "insert into " + this.insertFormDataConfig.TABLE_NAME + "(" + this.insertFormDataConfig.COLUMN_NAME + "," + this.insertFormDataConfig.FORM_NAME + ") values(?,?)";
            System.out.println("The query Stmt is " + queryStmt);
            ps = con.prepareStatement(queryStmt);
            ps.setString(1, writer.toString());
            ps.setString(2, AdaptiveFormName);
            ps.executeUpdate();
        }
        catch (Exception e) {
            System.out.println("The error message is " + e.getMessage());
        }
        System.out.println("***Adative Form Name is " + values[0]);
    }
}

