/*
 * Decompiled with CFR 0.152.
 */
package com.aemforms.ares.core.impl;

import com.adobe.aemfd.docmanager.Document;
import com.adobe.fd.docassurance.client.api.DocAssuranceService;
import com.adobe.fd.docassurance.client.api.ReaderExtensionOptions;
import com.adobe.fd.readerextensions.client.ReaderExtensionsOptionSpec;
import com.adobe.fd.readerextensions.client.UsageRights;
import com.adobe.fd.signatures.pdf.inputs.UnlockOptions;
import com.aemforms.ares.core.ReaderExtendPDF;
import com.mergeandfuse.getserviceuserresolver.GetResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ApplyUsageRights.class})
public class ApplyUsageRights
implements ReaderExtendPDF {
    @Reference
    DocAssuranceService docAssuranceService;
    @Reference
    GetResolver getResolver;
    Logger logger = LoggerFactory.getLogger(ApplyUsageRights.class);

    @Override
    public Document applyUsageRights(Document pdfDocument, UsageRights usageRights) {
        ReaderExtensionsOptionSpec reOptionsSpec = new ReaderExtensionsOptionSpec(usageRights, "Sample ARES");
        UnlockOptions unlockOptions = null;
        ReaderExtensionOptions reOptions = ReaderExtensionOptions.getInstance();
        reOptions.setCredentialAlias("ares");
        reOptions.setResourceResolver(this.getResolver.getFormsServiceResolver());
        reOptions.setReOptions(reOptionsSpec);
        System.out.println("Applying Usage");
        try {
            Document readerExtended = this.docAssuranceService.secureDocument(pdfDocument, null, null, reOptions, unlockOptions);
            reOptions.getResourceResolver().close();
            return readerExtended;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

