/*
 * Decompiled with CFR 0.152.
 */
package aemformsutilityfunctions.core.impl;

import aemformsutilityfunctions.core.AemFormsUtilities;
import com.adobe.aemfd.docmanager.Document;
import com.mergeandfuse.getserviceuserresolver.GetResolver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.ValueFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

@Component(immediate=true)
public class AemformsUtilitiesImpl
implements AemFormsUtilities {
    private static final Logger log = LoggerFactory.getLogger(AemformsUtilitiesImpl.class);
    @Reference
    GetResolver getResolver;

    @Override
    public Document createDDXFromMapOfDocuments(Map<String, Document> paramMap) {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        HashMap mapOfDocuments = new HashMap();
        org.w3c.dom.Document ddx = null;
        try {
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            ddx = docBuilder.newDocument();
            Element rootElement = ddx.createElementNS("http://ns.adobe.com/DDX/1.0/", "DDX");
            ddx.appendChild(rootElement);
            Element pdfResult = ddx.createElement("PDF");
            pdfResult.setAttribute("result", "GeneratedDocument.pdf");
            rootElement.appendChild(pdfResult);
            for (String key : mapOfDocuments.keySet()) {
                log.debug(key + " " + mapOfDocuments.get(key));
                Element pdfSourceElement = ddx.createElement("PDF");
                pdfSourceElement.setAttribute("source", key);
                pdfResult.appendChild(pdfSourceElement);
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return this.orgw3cDocumentToAEMFDDocument(ddx);
    }

    @Override
    public String saveDocumentInCrx(String jcrPath, String fileExtension, Document documentToSave) {
        log.debug("Storing in CRX  " + jcrPath);
        ResourceResolver serviceResolver = this.getResolver.getFormsServiceResolver();
        Node nodePath = (Node)serviceResolver.getResource(jcrPath).adaptTo(Node.class);
        UUID uuid = UUID.randomUUID();
        String uuidString = uuid.toString();
        try {
            Node addedFileNode = nodePath.addNode(uuidString + fileExtension, "nt:file");
            Node resNode = addedFileNode.addNode("jcr:content", "nt:resource");
            Session session = (Session)serviceResolver.adaptTo(Session.class);
            ValueFactory valueFactory = session.getValueFactory();
            Binary contentValue = valueFactory.createBinary(documentToSave.getInputStream());
            resNode.setProperty("jcr:data", contentValue);
            serviceResolver.commit();
            log.debug("Added file " + uuidString + "with extension " + fileExtension + "in the path " + addedFileNode.getPath());
            return addedFileNode.getPath();
        }
        catch (Exception e) {
            log.debug(e.getMessage());
            return null;
        }
    }

    @Override
    public Document orgw3cDocumentToAEMFDDocument(org.w3c.dom.Document xmlDocument) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DOMSource source = new DOMSource(xmlDocument);
        log.debug("$$$$In orgW3CDocumentToAEMFDDocument method");
        StreamResult outputTarget = new StreamResult(outputStream);
        try {
            TransformerFactory.newInstance().newTransformer().transform(source, outputTarget);
        }
        catch (Exception e) {
            log.debug(e.getMessage());
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        Document xmlAEMFDDocument = new Document((InputStream)inputStream);
        return xmlAEMFDDocument;
    }

    @Override
    public org.w3c.dom.Document w3cDocumentFromStrng(String xmlString) {
        try {
            log.debug("Inside w3cDocumentFromString");
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xmlString));
            return db.parse(is);
        }
        catch (Exception e) {
            log.debug(e.getMessage());
            return null;
        }
    }
}

