package com.aemformscs.documentservices;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;

import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;



public class DocumentGeneration {
	public String SAVE_LOCATION = "c:\\aspire1";
	
	public void mergeDataWithXdpTemplate(String postURL)
	{
		HttpPost httpPost = new HttpPost(postURL);
		CredentialUtilites cu = new CredentialUtilites();
		String accessToken = cu.getAccessToken();
		httpPost.addHeader("Authorization", "Bearer " + accessToken);
		ClassLoader classLoader = DocumentGeneration.class.getClassLoader();
		URL templateFile = classLoader.getResource("templates/custom_fonts.xdp");
		File xdpTemplate = new File(templateFile.getPath());
		URL url = classLoader.getResource("datafiles");
		System.out.println(url.getPath());
		File files[] = new File(url.getPath()).listFiles();
		for(int i=0;i<files.length;i++)
		{
			 MultipartEntityBuilder builder = MultipartEntityBuilder.create();
		  		ContentType strContent = ContentType.create("text/plain",Charset.forName("UTF-8"));
		  		builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
		  		builder.addBinaryBody("data",files[i]);
		  		builder.addBinaryBody("template",xdpTemplate);
		  		// You can also pass a URL for the template and set the content type to text/plain
		  		builder.addTextBody("template", "https://forms.enablementadobe.com/content/ocrfiles/address.xdp",ContentType.TEXT_PLAIN);
		  		builder.addBinaryBody("options",GetOptions.getPDFOptions().getBytes(),ContentType.APPLICATION_JSON,"options");
		  		try
		  		{
		  			HttpEntity entity = builder.build();
	  				httpPost.setEntity(entity);
	  				CloseableHttpClient httpclient = HttpClients.createDefault();
	  				CloseableHttpResponse response = httpclient.execute(httpPost);
	  				InputStream generatedPDF = response.getEntity().getContent();
	  				byte[] bytes = IOUtils.toByteArray(generatedPDF);
	  				File saveLocation = new File(SAVE_LOCATION);
	  				if(!saveLocation.exists())
	  				{
	  					saveLocation.mkdirs();
	  				}
	  				File outputFile = new File(SAVE_LOCATION+File.separator+files[i].getName().replace("xml", "pdf"));
	  				try (FileOutputStream outputStream = new FileOutputStream(outputFile))
	  				{
	  				    outputStream.write(bytes);
	  				  outputStream.close();
	  				}
		  		}
		  		catch(Exception e)
		  		{
		  			System.out.println("The error is "+e.getMessage());
		  		}
		  		
		}
		System.out.println("Done generating "+files.length+ " files");
		
		
		
		
	}

}
